/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.client;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.javax.common.UpgradeResponse;

public class DelegatedJavaxClientUpgradeResponse
implements UpgradeResponse {
    private HttpResponse delegate;

    public DelegatedJavaxClientUpgradeResponse(HttpResponse response) {
        this.delegate = response;
    }

    public String getAcceptedSubProtocol() {
        return this.delegate.getHeaders().get(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
    }

    public List<ExtensionConfig> getExtensions() {
        List rawExtensions = this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (rawExtensions == null || rawExtensions.isEmpty()) {
            return Collections.emptyList();
        }
        return rawExtensions.stream().map(parameterizedName -> ExtensionConfig.parse((String)parameterizedName)).collect(Collectors.toList());
    }
}

