/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.client;

import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrEvents;
import org.eclipse.jetty.websocket.jsr356.client.AnnotatedClientEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.endpoints.JsrAnnotatedEventDriver;

public class JsrClientEndpointImpl
implements EventDriverImpl {
    public EventDriver create(Object websocket, WebSocketPolicy policy) throws DeploymentException {
        if (!(websocket instanceof EndpointInstance)) {
            throw new IllegalStateException(String.format("Websocket %s must be an %s", websocket.getClass().getName(), EndpointInstance.class.getName()));
        }
        EndpointInstance ei = (EndpointInstance)websocket;
        AnnotatedClientEndpointMetadata metadata = (AnnotatedClientEndpointMetadata)ei.getMetadata();
        JsrEvents<ClientEndpoint, ClientEndpointConfig> events = new JsrEvents<ClientEndpoint, ClientEndpointConfig>(metadata);
        return new JsrAnnotatedEventDriver(policy, ei, events);
    }

    public String describeRule() {
        return "class is annotated with @" + ClientEndpoint.class.getName();
    }

    public boolean supports(Object websocket) {
        if (!(websocket instanceof EndpointInstance)) {
            return false;
        }
        EndpointInstance ei = (EndpointInstance)websocket;
        Object endpoint = ei.getEndpoint();
        ClientEndpoint anno = endpoint.getClass().getAnnotation(ClientEndpoint.class);
        return anno != null;
    }
}

