/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.toolchain.version.issues.Issue;
import org.eclipse.jetty.toolchain.version.issues.IssuePatterns;
import org.eclipse.jetty.toolchain.version.issues.IssueSyntax;

public class IssueParser {
    public static final String REGEX_ISSUE_BULLET = "^ [\\*\\+-] ";
    private static final IssuePatterns ISSUE_ID_PATTERNS;

    public Issue parseKnownIssue(String rawissue) {
        String raw = rawissue;
        if (StringUtils.isBlank((String)(raw = raw.replaceFirst(REGEX_ISSUE_BULLET, "")))) {
            return null;
        }
        Issue issue = this.parsePossibleIssue(raw);
        if (issue != null) {
            return issue;
        }
        raw = raw.trim();
        String badId = raw.substring(0, Math.min(raw.length(), 70)).toLowerCase();
        issue = new Issue(badId, raw, IssueSyntax.BAD);
        return issue;
    }

    public Issue parsePossibleIssue(String rawissue) {
        if (StringUtils.isBlank((String)rawissue)) {
            return null;
        }
        String subject = rawissue.trim();
        IssuePatterns.Match match = ISSUE_ID_PATTERNS.find(subject);
        if (match == null) {
            return null;
        }
        String id = match.group(1);
        if (match.syntax != IssueSyntax.BAD) {
            subject = subject.substring(match.end());
            subject = this.cleanSubjectLine(subject);
        }
        Issue issue = new Issue(id, subject, match.syntax);
        return issue;
    }

    public void findPossibleIssueIds(String line, Collection<String> foundIssueIds) {
        if (StringUtils.isBlank((String)line)) {
            return;
        }
        foundIssueIds.addAll(ISSUE_ID_PATTERNS.findAllIds(line.trim()));
    }

    private String cleanSubjectLine(String subject) {
        Pattern parenWrapped;
        Pattern endPunctuation;
        Matcher mat;
        if (subject.startsWith("- ")) {
            subject = subject.substring(2);
        }
        if ((mat = (endPunctuation = Pattern.compile("^(.*)\\s*[\\.!,]+\\s*$")).matcher(subject)).matches()) {
            subject = mat.group(1);
        }
        if ((mat = (parenWrapped = Pattern.compile("^\\s*\\((.*)\\)\\s*$")).matcher(subject)).matches()) {
            subject = mat.group(1);
        }
        return subject.trim();
    }

    static {
        String DELIM = "[-\\[\\]: ]*";
        ISSUE_ID_PATTERNS = new IssuePatterns();
        ISSUE_ID_PATTERNS.add(IssueSyntax.GITHUB, "^[\\[\\s]*Issue #?([0-9]{2,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.GITHUB, "^[\\[\\s]*#?([0-9]{2,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.GITHUB_RECOMMENDED, "^[\\[\\s]*Close #([0-9]{2,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.GITHUB_RECOMMENDED, "^[\\[\\s]*Close[sd]* #([0-9]{2,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.GITHUB_RECOMMENDED, "^[\\[\\s]*Fix #([0-9]{1,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.GITHUB_RECOMMENDED, "^[\\[\\s]*Fixe[sd]* #([0-9]{2,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.GITHUB_RECOMMENDED, "^[\\[\\s]*Resolve #([0-9]{2,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.GITHUB_RECOMMENDED, "^[\\[\\s]*Resolve[sd]* #([0-9]{2,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.BUGZILLA, "^[\\[\\s]*Bug ([0-9]{6,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.BUGZILLA, "^([0-9]{6,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.JIRA, "^[\\[\\s]*Bug (JETTY-[0-9]{2,})[-\\[\\]: ]*");
        ISSUE_ID_PATTERNS.add(IssueSyntax.JIRA, "(JETTY-[0-9]{2,})[^0-9]");
        ISSUE_ID_PATTERNS.add(IssueSyntax.BAD, "#([0-9]{2,})");
    }
}

