/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.git;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.toolchain.version.util.DateUtil;

public class GitCommit {
    private Date authorDate;
    private String authorName;
    private List<String> body = new ArrayList<String>();
    private String commitId;
    private Date committerDate;
    private String committerName;
    private String subject;
    private List<String> filenames = new ArrayList<String>();
    private Set<String> issueIds;

    public void addFilename(String filename) {
        this.filenames.add(filename);
    }

    public void addBodyLine(String line) {
        this.body.add(line);
    }

    public Date getAuthorDate() {
        return this.authorDate;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public List<String> getBody() {
        return this.body;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public Date getCommitterDate() {
        return this.committerDate;
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public Set<String> getIssueIds() {
        return this.issueIds;
    }

    public String getSubject() {
        return this.subject;
    }

    public void parseAuthorDate(String rawdate) throws ParseException {
        if (StringUtils.isBlank((String)rawdate)) {
            this.authorDate = null;
            return;
        }
        this.authorDate = DateUtil.parseIso8601(rawdate);
    }

    public void parseCommitterDate(String rawdate) throws ParseException {
        if (StringUtils.isBlank((String)rawdate)) {
            this.committerDate = null;
            return;
        }
        this.committerDate = DateUtil.parseIso8601(rawdate);
    }

    public void setAuthorDate(Date authorDate) {
        this.authorDate = authorDate;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    public void setCommitterDate(Date committerDate) {
        this.committerDate = committerDate;
    }

    public void setCommitterName(String committerName) {
        this.committerName = committerName;
    }

    public void setFilenames(List<String> filteredFilenames) {
        this.filenames.clear();
        this.filenames.addAll(filteredFilenames);
    }

    public void setIssueIds(Set<String> issueIds) {
        this.issueIds = issueIds;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }
}

