/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.git;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jetty.toolchain.version.git.GitOutputParser;

public class OutputHandler
extends Thread {
    private final InputStream in;
    private final Log log;
    private final GitOutputParser parser;

    public OutputHandler(Log log, InputStream in, GitOutputParser parser) {
        this.log = log;
        this.in = in;
        this.parser = parser;
    }

    @Override
    public void run() {
        int linenum;
        block14: {
            linenum = 0;
            this.parser.parseStart();
            try (InputStreamReader reader = new InputStreamReader(this.in);
                 BufferedReader buf = new BufferedReader(reader);){
                String line;
                while ((line = buf.readLine()) != null) {
                    this.parser.parseLine(++linenum, line);
                }
            }
            catch (ParseException e) {
                this.log.debug((Throwable)e);
            }
            catch (IOException e) {
                if (e.getMessage().equalsIgnoreCase("Stream closed")) break block14;
                this.log.debug((Throwable)e);
            }
        }
        this.parser.parseEnd();
        this.log.debug((CharSequence)("Parsed " + linenum + " lines of output"));
    }
}

