/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import org.eclipse.jetty.toolchain.version.issues.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueComparator
implements Comparator<Issue> {
    private final Collator collator = Collator.getInstance();

    @Override
    public int compare(Issue o1, Issue o2) {
        CollationKey key1 = this.toKey(o1);
        CollationKey key2 = this.toKey(o2);
        return key1.compareTo(key2);
    }

    private CollationKey toKey(Issue issue) {
        if (issue == null || issue.getId() == null) {
            return this.collator.getCollationKey("");
        }
        if (issue.getId().startsWith("JETTY-")) {
            try {
                Integer num = Integer.parseInt(issue.getId().substring(6));
                return this.collator.getCollationKey(String.format("JETTY-%06d", num));
            }
            catch (NumberFormatException e) {
                return this.collator.getCollationKey(issue.getId());
            }
        }
        return this.collator.getCollationKey(issue.getId());
    }
}

