/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.eclipse.jetty.toolchain:jetty-version-maven-plugin:1.0.6", 0);
        this.append(sb, "", 0);
        this.append(sb, "Jetty:: Version Management Maven Plugin", 0);
        this.append(sb, "Build / Release Plugin for working with versions in jetty maven builds", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "attach-version-text".equals(this.goal)) {
            this.append(sb, "jetty-version:attach-version-text", 0);
            this.append(sb, "Attach the VERSION.txt to the project.\nWill only attach the VERSION.txt if it exists.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The project basedir.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "The classifier to use for attaching the generated VERSION.txt artifact", 3);
                this.append(sb, "", 0);
                this.append(sb, "type", 2);
                this.append(sb, "The type to use for the attaching the generated VERSION.txt artifact", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionTextInputFile (Default: ${project.basedir}/VERSION.txt)", 2);
                this.append(sb, "The existing VERSION.txt file.", 3);
                this.append(sb, "Expression: ${version.text.file}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jetty-version:help", 0);
            this.append(sb, "Display help information on jetty-version-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jetty-version:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-version-text".equals(this.goal)) {
            this.append(sb, "jetty-version:update-version-text", 0);
            this.append(sb, "Update the active version entry in the VERSION.txt file from information present in the git logs.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attachArtifact (Default: false)", 2);
                this.append(sb, "Allow the plugin to attach the generated VERSION.txt file to the project", 3);
                this.append(sb, "Expression: ${version.attach}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The project basedir.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "The classifier to use for attaching the generated VERSION.txt artifact", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyGenerated (Default: false)", 2);
                this.append(sb, "Allow the plugin to replace the input VERSION.txt file", 3);
                this.append(sb, "Expression: ${version.copy.generated}", 3);
                this.append(sb, "", 0);
                this.append(sb, "refreshTags (Default: false)", 2);
                this.append(sb, "Allow the plugin to issue a 'git fetch --tags' to update the local tags from.", 3);
                this.append(sb, "Expression: ${version.refresh.tags}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sortExisting (Default: false)", 2);
                this.append(sb, "Allow the existing issues to be sorted alphabetically.", 3);
                this.append(sb, "Expression: ${version.sort.existing}", 3);
                this.append(sb, "", 0);
                this.append(sb, "type", 2);
                this.append(sb, "The type to use for the attaching the generated VERSION.txt artifact", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateDate (Default: false)", 2);
                this.append(sb, "Allow the plugin to update the release date for an issue (if none is provided)", 3);
                this.append(sb, "Expression: ${version.update.date}", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: ${project.version})", 2);
                this.append(sb, "The maven project version.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${version.section}", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionTagKey (Default: jetty-VERSION)", 2);
                this.append(sb, "The version key to use when looking up a git tag ref.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${version.tag.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionTextInputFile (Default: ${project.basedir}/VERSION.txt)", 2);
                this.append(sb, "The existing VERSION.txt file.", 3);
                this.append(sb, "Expression: ${version.text.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionTextKey (Default: jetty-VERSION)", 2);
                this.append(sb, "The version key to use in the VERSION.txt file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${version.text.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionTextOuputFile (Default: ${project.build.directory}/VERSION.txt)", 2);
                this.append(sb, "The generated VERSION.txt file.", 3);
                this.append(sb, "Expression: ${version.text.output.file}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

