/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.git;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.git.Git2LogParser;
import org.eclipse.jetty.toolchain.version.git.GitCommit;
import org.eclipse.jetty.toolchain.version.git.GitLogParser;
import org.eclipse.jetty.toolchain.version.git.GitOutputParser;
import org.eclipse.jetty.toolchain.version.git.GitTagParser;
import org.eclipse.jetty.toolchain.version.git.OutputHandler;
import org.eclipse.jetty.toolchain.version.issues.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCommand {
    private Log log;
    private File workDir;

    private int execGitCommand(GitOutputParser outputParser, String ... commands) throws IOException {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder dbg = new StringBuilder();
            for (String cmd : commands) {
                dbg.append(" ").append(cmd);
            }
            this.getLog().debug((CharSequence)("Command Line:" + dbg.toString()));
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.directory(this.getWorkDir());
        Process process = pb.start();
        InputStream in = null;
        try {
            in = process.getInputStream();
            OutputHandler handler = new OutputHandler(this.getLog(), in, outputParser);
            handler.start();
            int exitCode = process.waitFor();
            this.getLog().debug((CharSequence)("Exit code: " + exitCode));
            handler.join();
            int n = exitCode;
            return n;
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)"Git Process didn't complete", (Throwable)e);
            throw new IOException("Git Process did not complete");
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    public boolean fetchTags() throws IOException {
        Git2LogParser logout = new Git2LogParser(this.log, "fetch tags");
        int exitCode = this.execGitCommand(logout, "git", "fetch", "--tags");
        return exitCode == 0;
    }

    public String findTagMatching(String version) throws IOException {
        this.log.debug((CharSequence)("findTagMatching(" + version + ")"));
        if (version != null) {
            for (String tag : this.getTags()) {
                this.log.debug((CharSequence)("[tag] \"" + tag + "\""));
                if (!tag.startsWith(version)) continue;
                return "tags/" + tag;
            }
        }
        return null;
    }

    public List<GitCommit> getCommitLog(String fromCommitId) throws IOException {
        GitLogParser logs = new GitLogParser();
        this.execGitCommand(logs, "git", "log", fromCommitId + "..HEAD", logs.getFormat());
        return logs.getGitCommitLogs();
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public String getTagCommitId(String tagId) throws IOException {
        GitLogParser logs = new GitLogParser();
        this.execGitCommand(logs, "git", "log", "-1", tagId, logs.getFormat());
        this.getLog().debug((CharSequence)("Captured " + logs.getGitCommitLogs().size() + " log entries"));
        GitCommit commit = logs.getGitCommitLog(0);
        return commit.getCommitId();
    }

    public List<String> getTags() throws IOException {
        GitTagParser tags = new GitTagParser();
        this.execGitCommand(tags, "git", "tag", "-l");
        return tags.getTagIds();
    }

    public File getWorkDir() {
        if (this.workDir == null) {
            this.workDir = new File(System.getProperty("user.dir"));
        }
        return this.workDir;
    }

    public void populateIssuesForRange(String fromCommitId, String toCommitId, Release rel) throws IOException {
        GitLogParser parser = new GitLogParser();
        this.execGitCommand(parser, "git", "log", fromCommitId + ".." + toCommitId, parser.getFormat());
        this.getLog().debug((CharSequence)("Captured " + parser.getGitCommitLogs().size() + " log entries"));
        List<Issue> issues = parser.getIssues();
        this.getLog().debug((CharSequence)("Found " + issues.size() + " issues in git log"));
        rel.setExisting(false);
        rel.addIssues(issues);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setWorkDir(File basedir) {
        this.workDir = basedir;
    }
}

