/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.git;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.git.GitCommit;
import org.eclipse.jetty.toolchain.version.git.GitLogParser;
import org.eclipse.jetty.toolchain.version.git.GitOutputParser;
import org.eclipse.jetty.toolchain.version.git.GitTagParser;
import org.eclipse.jetty.toolchain.version.issues.Issue;

public class GitCommand {
    private Log log;
    private File workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execGitCommand(GitOutputParser outputParser, String ... commands) throws IOException {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder dbg = new StringBuilder();
            for (String cmd : commands) {
                dbg.append(" ").append(cmd);
            }
            this.getLog().debug((CharSequence)("Command Line:" + dbg.toString()));
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.directory(this.getWorkDir());
        Process process = pb.start();
        InputStream in = null;
        try {
            in = process.getInputStream();
            OutputHandler handler = new OutputHandler(this.getLog(), in, outputParser);
            handler.start();
            this.getLog().debug((CharSequence)("Exit code: " + process.waitFor()));
            handler.join();
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)"Process didn't complete", (Throwable)e);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    public String findTagMatching(String version) throws IOException {
        for (String tag : this.getTags()) {
            if (!tag.startsWith(version)) continue;
            return "tags/" + tag;
        }
        return null;
    }

    public List<GitCommit> getCommitLog(String fromCommitId) throws IOException {
        GitLogParser logs = new GitLogParser();
        this.execGitCommand(logs, "git", "log", fromCommitId + "..HEAD", logs.getFormat());
        return logs.getGitCommitLogs();
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public String getTagCommitId(String tagId) throws IOException {
        GitLogParser logs = new GitLogParser();
        this.execGitCommand(logs, "git", "log", "-1", tagId, logs.getFormat());
        this.getLog().debug((CharSequence)("Captured " + logs.getGitCommitLogs().size() + " log entries"));
        GitCommit commit = logs.getGitCommitLog(0);
        return commit.getCommitId();
    }

    public List<String> getTags() throws IOException {
        GitTagParser tags = new GitTagParser();
        this.execGitCommand(tags, "git", "tag", "-l");
        return tags.getTagIds();
    }

    public File getWorkDir() {
        if (this.workDir == null) {
            this.workDir = new File(System.getProperty("user.dir"));
        }
        return this.workDir;
    }

    public void populateIssuesForRange(String fromCommitId, String toCommitId, Release rel) throws IOException {
        GitLogParser parser = new GitLogParser();
        this.execGitCommand(parser, "git", "log", fromCommitId + ".." + toCommitId, parser.getFormat());
        this.getLog().debug((CharSequence)("Captured " + parser.getGitCommitLogs().size() + " log entries"));
        List<Issue> issues = parser.getIssues();
        this.getLog().info((CharSequence)("Found " + issues.size() + " issues"));
        rel.setExisting(false);
        rel.addIssues(issues);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setWorkDir(File basedir) {
        this.workDir = basedir;
    }

    private static class OutputHandler
    extends Thread {
        private final InputStream in;
        private final Log log;
        private final GitOutputParser parser;

        public OutputHandler(Log log, InputStream in, GitOutputParser parser) {
            this.log = log;
            this.in = in;
            this.parser = parser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int linenum;
            block7: {
                linenum = 0;
                this.parser.parseStart();
                InputStreamReader reader = null;
                BufferedReader buf = null;
                try {
                    String line;
                    reader = new InputStreamReader(this.in);
                    buf = new BufferedReader(reader);
                    while ((line = buf.readLine()) != null) {
                        this.parser.parseLine(++linenum, line);
                    }
                    IOUtil.close((Reader)buf);
                }
                catch (IOException e) {
                    if (!e.getMessage().equalsIgnoreCase("Stream closed")) {
                        this.log.debug((Throwable)e);
                    }
                    break block7;
                }
                finally {
                    IOUtil.close(buf);
                    IOUtil.close((Reader)reader);
                }
                IOUtil.close((Reader)reader);
            }
            this.parser.parseEnd();
            this.log.debug((CharSequence)("Parsed " + linenum + " lines of output"));
        }
    }
}

