/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;

public final class PathAssert {
    private PathAssert() {
    }

    public static void assertDirExists(String msg, File path) {
        PathAssert.assertPathExists(msg, path);
        Assertions.assertTrue((boolean)path.isDirectory(), (String)(msg + " path should be a Dir : " + path.getAbsolutePath()));
    }

    public static void assertDirExists(String msg, Path path) {
        PathAssert.assertPathExists(msg, path);
        Assertions.assertTrue((boolean)Files.isDirectory(path, new LinkOption[0]), (String)(msg + " path should be a Dir : " + path));
    }

    public static void assertFileExists(String msg, File path) {
        PathAssert.assertPathExists(msg, path);
        Assertions.assertTrue((boolean)path.isFile(), (String)(msg + " path should be a File : " + path.getAbsolutePath()));
    }

    public static void assertFileExists(String msg, Path path) {
        PathAssert.assertPathExists(msg, path);
        Assertions.assertTrue((boolean)Files.isRegularFile(path, new LinkOption[0]), (String)(msg + " path should be a File : " + path));
    }

    public static void assertPathExists(String msg, File path) {
        Assertions.assertTrue((boolean)path.exists(), (String)(msg + " path should exist: " + path.getAbsolutePath()));
    }

    public static void assertPathExists(String msg, Path path) {
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]), (String)(msg + " path should exist: " + path));
    }

    public static void assertNotPathExists(String msg, File path) {
        Assertions.assertFalse((boolean)path.exists(), (String)(msg + " path should not exist: " + path.getAbsolutePath()));
    }

    public static void assertNotPathExists(String msg, Path path) {
        Assertions.assertFalse((boolean)Files.exists(path, new LinkOption[0]), (String)(msg + " path should not exist: " + path));
    }
}

