/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

public class JDK {
    public static final boolean IS_5 = JDK.isJavaVersionAtLeast(1, 5);
    public static final boolean IS_6 = JDK.isJavaVersionAtLeast(1, 6);
    public static final boolean IS_7 = JDK.isJavaVersionAtLeast(1, 7);
    public static final boolean IS_8 = JDK.isJavaVersionAtLeast(1, 8);
    public static final boolean IS_9 = JDK.isJavaVersionAtLeast(9, 0);

    private static boolean isJavaVersionAtLeast(int maj, int min) {
        String jvmSpecVer = System.getProperty("java.vm.specification.version");
        if (jvmSpecVer == null) {
            System.err.println("## ERROR: System.getProperty('java.vm.specification.version') == null !?");
            return false;
        }
        String[] versionParts = jvmSpecVer.split("[-.]");
        int actualMaj = 0;
        int actualMin = 0;
        if (versionParts.length > 0) {
            actualMaj = JDK.toInt(versionParts[0]);
            if (versionParts.length > 1) {
                actualMin = JDK.toInt(versionParts[1]);
            }
        }
        return actualMaj > maj || actualMaj == maj && actualMin >= min;
    }

    private static int toInt(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

