/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jetty.toolchain.test.FS;

public final class IO {
    public static final int BUFFER_SIZE = 65536;

    private IO() {
    }

    public static void copy(Reader in, Writer out) throws IOException {
        char[] buffer = new char[65536];
        int len = 65536;
        while ((len = in.read(buffer, 0, 65536)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(File file) throws IOException {
        String string;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            StringWriter writer = new StringWriter();
            IO.copy(reader, writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            IO.close(reader);
            throw throwable;
        }
        IO.close(reader);
        return string;
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            IO.copyDir(from, to);
        } else {
            IO.copyFile(from, to);
        }
    }

    public static void copyDir(File from, File to) throws IOException {
        FS.ensureDirExists(to);
        for (File file : from.listFiles(SafeFileFilter.INSTANCE)) {
            IO.copy(file, new File(to, file.getName()));
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[65536];
        int len = 65536;
        while ((len = in.read(buffer, 0, 65536)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            IO.copy(in, out);
        }
        catch (Throwable throwable) {
            IO.close(out);
            IO.close(in);
            throw throwable;
        }
        IO.close(out);
        IO.close(in);
    }

    public static class SafeFileFilter
    implements FileFilter {
        public static final SafeFileFilter INSTANCE = new SafeFileFilter();

        public boolean accept(File path) {
            String name = path.getName();
            if (".".equals(name) || "..".equals(name)) {
                return false;
            }
            return path.isFile() || path.isDirectory();
        }
    }
}

