/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BenchmarkHelper
implements Runnable {
    private final java.lang.management.OperatingSystemMXBean operatingSystem;
    private final CompilationMXBean jitCompiler;
    private final MemoryMXBean heapMemory;
    private final AtomicInteger starts = new AtomicInteger();
    private volatile MemoryPoolMXBean youngMemoryPool;
    private volatile MemoryPoolMXBean survivorMemoryPool;
    private volatile MemoryPoolMXBean oldMemoryPool;
    private volatile boolean hasMemoryPools;
    private volatile ScheduledFuture<?> memoryPoller;
    private volatile GarbageCollectorMXBean youngCollector;
    private volatile GarbageCollectorMXBean oldCollector;
    private volatile boolean hasCollectors;
    private volatile ScheduledExecutorService scheduler;
    private volatile boolean polling;
    private volatile long lastYoungUsed;
    private volatile long startYoungCollections;
    private volatile long startYoungCollectionsTime;
    private volatile long totalYoungUsed;
    private volatile long lastSurvivorUsed;
    private volatile long totalSurvivorUsed;
    private volatile long lastOldUsed;
    private volatile long startOldCollections;
    private volatile long startOldCollectionsTime;
    private volatile long totalOldUsed;
    private volatile long startTime;
    private volatile long startProcessCPUTime;
    private volatile long startJITCTime;

    public BenchmarkHelper() {
        this.operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        this.jitCompiler = ManagementFactory.getCompilationMXBean();
        this.heapMemory = ManagementFactory.getMemoryMXBean();
        List<MemoryPoolMXBean> memoryPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPool : memoryPools) {
            if ("PS Eden Space".equals(memoryPool.getName()) || "Par Eden Space".equals(memoryPool.getName()) || "G1 Eden".equals(memoryPool.getName())) {
                this.youngMemoryPool = memoryPool;
                continue;
            }
            if ("PS Survivor Space".equals(memoryPool.getName()) || "Par Survivor Space".equals(memoryPool.getName()) || "G1 Survivor".equals(memoryPool.getName())) {
                this.survivorMemoryPool = memoryPool;
                continue;
            }
            if (!"PS Old Gen".equals(memoryPool.getName()) && !"CMS Old Gen".equals(memoryPool.getName()) && !"G1 Old Gen".equals(memoryPool.getName())) continue;
            this.oldMemoryPool = memoryPool;
        }
        this.hasMemoryPools = this.youngMemoryPool != null && this.survivorMemoryPool != null && this.oldMemoryPool != null;
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollector : garbageCollectors) {
            if ("PS Scavenge".equals(garbageCollector.getName()) || "ParNew".equals(garbageCollector.getName()) || "G1 Young Generation".equals(garbageCollector.getName())) {
                this.youngCollector = garbageCollector;
                continue;
            }
            if (!"PS MarkSweep".equals(garbageCollector.getName()) && !"ConcurrentMarkSweep".equals(garbageCollector.getName()) && !"G1 Old Generation".equals(garbageCollector.getName())) continue;
            this.oldCollector = garbageCollector;
        }
        this.hasCollectors = this.youngCollector != null && this.oldCollector != null;
    }

    public void run() {
        if (!this.hasMemoryPools) {
            return;
        }
        long young = this.youngMemoryPool.getUsage().getUsed();
        long survivor = this.survivorMemoryPool.getUsage().getUsed();
        long old = this.oldMemoryPool.getUsage().getUsed();
        if (!this.polling) {
            this.polling = true;
        } else {
            if (this.lastYoungUsed <= young) {
                this.totalYoungUsed += young - this.lastYoungUsed;
            }
            if (this.lastSurvivorUsed <= survivor) {
                this.totalSurvivorUsed += survivor - this.lastSurvivorUsed;
            }
            if (this.lastOldUsed <= old) {
                this.totalOldUsed += old - this.lastOldUsed;
            }
        }
        this.lastYoungUsed = young;
        this.lastSurvivorUsed = survivor;
        this.lastOldUsed = old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startStatistics() {
        BenchmarkHelper benchmarkHelper = this;
        synchronized (benchmarkHelper) {
            if (this.starts.incrementAndGet() > 1) {
                return false;
            }
            System.gc();
            System.err.println("\n========================================");
            System.err.println("Statistics Started at " + new Date());
            System.err.println("Operative System: " + this.operatingSystem.getName() + " " + this.operatingSystem.getVersion() + " " + this.operatingSystem.getArch());
            System.err.println("JVM : " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " runtime " + System.getProperty("java.vm.version") + " " + System.getProperty("java.runtime.version"));
            System.err.println("Processors: " + this.operatingSystem.getAvailableProcessors());
            if (this.operatingSystem instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean os = (OperatingSystemMXBean)this.operatingSystem;
                long totalMemory = os.getTotalPhysicalMemorySize();
                long freeMemory = os.getFreePhysicalMemorySize();
                System.err.println("System Memory: " + this.percent(totalMemory - freeMemory, totalMemory) + "% used of " + this.gibiBytes(totalMemory) + " GiB");
            } else {
                System.err.println("System Memory: N/A");
            }
            MemoryUsage heapMemoryUsage = this.heapMemory.getHeapMemoryUsage();
            System.err.println("Used Heap Size: " + this.mebiBytes(heapMemoryUsage.getUsed()) + " MiB");
            System.err.println("Max Heap Size: " + this.mebiBytes(heapMemoryUsage.getMax()) + " MiB");
            if (this.hasMemoryPools) {
                long youngGenerationHeap = heapMemoryUsage.getMax() - this.oldMemoryPool.getUsage().getMax();
                System.err.println("Young Generation Heap Size: " + this.mebiBytes(youngGenerationHeap) + " MiB");
            } else {
                System.err.println("Young Generation Heap Size: N/A");
            }
            System.err.println("- - - - - - - - - - - - - - - - - - - - ");
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.polling = false;
            this.memoryPoller = this.scheduler.scheduleWithFixedDelay(this, 0L, 250L, TimeUnit.MILLISECONDS);
            this.lastYoungUsed = 0L;
            if (this.hasCollectors) {
                this.startYoungCollections = this.youngCollector.getCollectionCount();
                this.startYoungCollectionsTime = this.youngCollector.getCollectionTime();
            }
            this.totalYoungUsed = 0L;
            this.lastSurvivorUsed = 0L;
            this.totalSurvivorUsed = 0L;
            this.lastOldUsed = 0L;
            if (this.hasCollectors) {
                this.startOldCollections = this.oldCollector.getCollectionCount();
                this.startOldCollectionsTime = this.oldCollector.getCollectionTime();
            }
            this.totalOldUsed = 0L;
            this.startTime = System.nanoTime();
            if (this.operatingSystem instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean os = (OperatingSystemMXBean)this.operatingSystem;
                this.startProcessCPUTime = os.getProcessCpuTime();
            }
            this.startJITCTime = this.jitCompiler.getTotalCompilationTime();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopStatistics() {
        BenchmarkHelper benchmarkHelper = this;
        synchronized (benchmarkHelper) {
            if (this.starts.decrementAndGet() > 0) {
                return false;
            }
            this.memoryPoller.cancel(false);
            this.scheduler.shutdown();
            System.err.println("- - - - - - - - - - - - - - - - - - - - ");
            System.err.println("Statistics Ended at " + new Date());
            long elapsedTime = System.nanoTime() - this.startTime;
            System.err.println("Elapsed time: " + TimeUnit.NANOSECONDS.toMillis(elapsedTime) + " ms");
            long elapsedJITCTime = this.jitCompiler.getTotalCompilationTime() - this.startJITCTime;
            System.err.println("\tTime in JIT compilation: " + elapsedJITCTime + " ms");
            if (this.hasCollectors) {
                long elapsedYoungCollectionsTime = this.youngCollector.getCollectionTime() - this.startYoungCollectionsTime;
                long youngCollections = this.youngCollector.getCollectionCount() - this.startYoungCollections;
                System.err.println("\tTime in Young Generation GC: " + elapsedYoungCollectionsTime + " ms (" + youngCollections + " collections)");
                long elapsedOldCollectionsTime = this.oldCollector.getCollectionTime() - this.startOldCollectionsTime;
                long oldCollections = this.oldCollector.getCollectionCount() - this.startOldCollections;
                System.err.println("\tTime in Old Generation GC: " + elapsedOldCollectionsTime + " ms (" + oldCollections + " collections)");
            } else {
                System.err.println("\tTime in GC: N/A");
            }
            if (this.hasMemoryPools) {
                System.err.println("Garbage Generated in Young Generation: " + this.mebiBytes(this.totalYoungUsed) + " MiB");
                System.err.println("Garbage Generated in Survivor Generation: " + this.mebiBytes(this.totalSurvivorUsed) + " MiB");
                System.err.println("Garbage Generated in Old Generation: " + this.mebiBytes(this.totalOldUsed) + " MiB");
            } else {
                System.err.println("Garbage Generated: N/A");
            }
            if (this.operatingSystem instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean os = (OperatingSystemMXBean)this.operatingSystem;
                long elapsedProcessCPUTime = os.getProcessCpuTime() - this.startProcessCPUTime;
                System.err.println("Average CPU Load: " + (float)elapsedProcessCPUTime * 100.0f / (float)elapsedTime + "/" + 100 * this.operatingSystem.getAvailableProcessors());
            } else {
                System.err.println("Average CPU Load: N/A");
            }
            System.err.println("----------------------------------------\n");
            return true;
        }
    }

    public float percent(long dividend, long divisor) {
        return (float)dividend * 100.0f / (float)divisor;
    }

    public float mebiBytes(long bytes) {
        return (float)bytes / 1024.0f / 1024.0f;
    }

    public float gibiBytes(long bytes) {
        return (float)bytes / 1024.0f / 1024.0f / 1024.0f;
    }
}

