/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.OS;
import org.eclipse.jetty.toolchain.test.PathAssert;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenTestingUtils {
    private static File basedir;
    private static URI baseURI;
    private static File testResourcesDir;
    private static File targetDir;

    private MavenTestingUtils() {
    }

    public static File getBasedir() {
        if (basedir == null) {
            String cwd = System.getProperty("basedir");
            if (cwd == null) {
                cwd = System.getProperty("user.dir");
            }
            basedir = new File(cwd);
            baseURI = basedir.toURI();
        }
        return basedir;
    }

    public static URI getBaseURI() {
        if (baseURI == null) {
            MavenTestingUtils.getBasedir();
        }
        return baseURI;
    }

    public static File getTargetDir() {
        if (targetDir == null) {
            targetDir = new File(MavenTestingUtils.getBasedir(), "target");
            PathAssert.assertDirExists("Target Dir", targetDir);
        }
        return targetDir;
    }

    public static File getTargetFile(String path) {
        return new File(MavenTestingUtils.getTargetDir(), OS.separators(path));
    }

    public static File getTargetTestingDir() {
        return new File(MavenTestingUtils.getTargetDir(), "tests");
    }

    public static File getTargetTestingDir(String testname) {
        return new File(MavenTestingUtils.getTargetTestingDir(), "test-" + testname);
    }

    public static File getTargetTestingDir(TestCase test) {
        return MavenTestingUtils.getTargetTestingDir(test.getName());
    }

    public static URI getTargetURI(String path) throws MalformedURLException {
        return MavenTestingUtils.getBaseURI().resolve("target/").resolve(path);
    }

    public static URL getTargetURL(String path) throws MalformedURLException {
        return MavenTestingUtils.getTargetURI(path).toURL();
    }

    public static File getTargetTestingDir(Class<?> testclass, String testmethodname) {
        String classname = testclass.getName();
        String methodname = testmethodname;
        classname = MavenTestingUtils.condensePackageString(classname);
        if (OS.IS_WINDOWS) {
            methodname = MavenTestingUtils.maxStringLength(30, methodname);
        }
        File testsDir = new File(MavenTestingUtils.getTargetDir(), "tests");
        File dir = new File(testsDir, classname + File.separatorChar + methodname);
        FS.ensureDirExists(dir);
        return dir;
    }

    public static String getTestIDAsPath() {
        TestID id = MavenTestingUtils.getTestID();
        id.classname = MavenTestingUtils.condensePackageString(id.classname);
        if (OS.IS_WINDOWS) {
            id.methodname = MavenTestingUtils.maxStringLength(30, id.methodname);
        }
        return id.classname + File.separatorChar + id.methodname;
    }

    public static File getProjectFile(String path) {
        File file = new File(MavenTestingUtils.getBasedir(), OS.separators(path));
        PathAssert.assertFileExists("Project File", file);
        return file;
    }

    public static File getProjectDir(String path) {
        File dir = new File(MavenTestingUtils.getBasedir(), OS.separators(path));
        PathAssert.assertDirExists("Project Dir", dir);
        return dir;
    }

    private static TestID getTestID() {
        StackTraceElement[] stacked;
        for (StackTraceElement stack : stacked = new Throwable().getStackTrace()) {
            if (!stack.getClassName().endsWith("Test") || !stack.getMethodName().startsWith("test")) continue;
            TestID testid = new TestID();
            testid.classname = stack.getClassName();
            testid.methodname = stack.getMethodName();
            return testid;
        }
        String LN = System.getProperty("line.separator");
        StringBuilder err = new StringBuilder();
        err.append("Unable to find a TestID from a testcase that ");
        err.append("doesn't follow the standard naming rules.");
        err.append(LN);
        err.append("Test class name must end in \"*Test\".");
        err.append(LN);
        err.append("Test method name must start in \"test*\".");
        err.append(LN);
        err.append("Call to ").append(MavenTestingUtils.class.getSimpleName());
        err.append(".getTestID(), must occur from within stack frame of ");
        err.append("test method, not @Before, @After, @BeforeClass, ");
        err.append("@AfterClass, or Constructors of test case.");
        Assert.fail((String)err.toString());
        return null;
    }

    protected static String condensePackageString(String classname) {
        String[] parts = classname.split("\\.");
        StringBuilder dense = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            dense.append(parts[i].charAt(0));
        }
        dense.append('.').append(parts[parts.length - 1]);
        return dense.toString();
    }

    protected static String maxStringLength(int max, String raw) {
        int length = raw.length();
        if (length <= max) {
            return raw;
        }
        return raw.substring(0, 3) + "..." + raw.substring(length - max + 6);
    }

    public static File getTestResourceDir(String name) {
        File dir = new File(MavenTestingUtils.getTestResourcesDir(), OS.separators(name));
        PathAssert.assertDirExists("Test Resource Dir", dir);
        return dir;
    }

    public static File getTestResourceFile(String name) {
        File file = new File(MavenTestingUtils.getTestResourcesDir(), OS.separators(name));
        PathAssert.assertFileExists("Test Resource File", file);
        return file;
    }

    public static File getTestResourcePath(String name) {
        File path = new File(MavenTestingUtils.getTestResourcesDir(), OS.separators(name));
        PathAssert.assertExists("Test Resource Path", path);
        return path;
    }

    public static File getTestResourcesDir() {
        if (testResourcesDir == null) {
            testResourcesDir = new File(basedir, OS.separators("src/test/resources"));
            PathAssert.assertDirExists("Test Resources Dir", testResourcesDir);
        }
        return testResourcesDir;
    }

    private static class TestID {
        public String classname;
        public String methodname;

        private TestID() {
        }
    }
}

