/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.OS;
import org.junit.Assert;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class TestingDir
implements MethodRule {
    private File dir;

    public Statement apply(final Statement statement, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestingDir.this.dir = MavenTestingUtils.getTargetTestingDir(target.getClass(), method.getName());
                FS.ensureEmpty(TestingDir.this.dir);
                statement.evaluate();
            }
        };
    }

    public File getDir() {
        if (this.dir.exists()) {
            return this.dir;
        }
        Assert.assertTrue((String)"Creating testing dir", (boolean)this.dir.mkdirs());
        return this.dir;
    }

    public File getFile(String name) {
        return new File(this.dir, OS.separators(name));
    }

    public void ensureEmpty() {
        FS.ensureEmpty(this.dir);
    }

    public File getEmptyDir() {
        if (this.dir.exists()) {
            FS.ensureEmpty(this.dir);
            return this.dir;
        }
        Assert.assertTrue((String)"Creating testing dir", (boolean)this.dir.mkdirs());
        return this.dir;
    }
}

