/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.modifysources;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.shared.filtering.DefaultMavenFileFilter;
import org.apache.maven.shared.filtering.DefaultMavenResourcesFiltering;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Singleton
@Named(value="ee9-to-ee8")
public class ResourcesFiltering
extends DefaultMavenResourcesFiltering
implements MavenResourcesFiltering {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMavenResourcesFiltering.class);

    public List<String> getDefaultNonFilteredFileExtensions() {
        return Collections.emptyList();
    }

    @Inject
    public ResourcesFiltering(MavenFileFilter mavenFileFilter, BuildContext buildContext) {
        super((MavenFileFilter)new JettyMavenFileFilter(buildContext), buildContext);
    }

    public static class JettyMavenFileFilter
    extends DefaultMavenFileFilter
    implements MavenFileFilter {
        private BuildContext buildContext;

        @Inject
        public JettyMavenFileFilter(BuildContext buildContext) {
            super(buildContext);
            this.buildContext = buildContext;
        }

        public void copyFile(File from, File to, boolean filtering, List<FilterWrapper> filterWrappers, String encoding, boolean overwrite) throws MavenFilteringException {
            try {
                if (filtering && Files.exists(from.toPath(), new LinkOption[0])) {
                    String content = Files.readString(from.toPath());
                    content = StringUtils.replace((String)content, (String)"https://jakarta.ee/xml/ns/jakartaee https://jakarta.ee/xml/ns/jakartaee/web-app_5_0.xsd", (String)"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_4_0.xsd");
                    content = StringUtils.replace((String)content, (String)"https://jakarta.ee/xml/ns/jakartaee https://jakarta.ee/xml/ns/jakartaee/web-fragment_5_0.xsd", (String)"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-fragment_4_0.xsd");
                    content = StringUtils.replace((String)content, (String)"https://jakarta.ee/xml/ns/jakartaee", (String)"http://xmlns.jcp.org/xml/ns/javaee");
                    content = StringUtils.replace((String)content, (String)"jakarta.", (String)"javax.");
                    content = StringUtils.replace((String)content, (String)"jakarta/", (String)"javax/");
                    content = StringUtils.replace((String)content, (String)"ee9", (String)"ee8");
                    content = StringUtils.replace((String)content, (String)"EE9", (String)"EE8");
                    content = StringUtils.replace((String)content, (String)"version=\"5.0\"", (String)"version=\"4.0\"");
                    Files.writeString(to.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                    this.buildContext.refresh(to);
                }
            }
            catch (IOException e) {
                LOGGER.error("error copying file {} to {}", (Object)from, (Object)to);
                throw new MavenFilteringException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

