/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.modifysources;

import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.DefaultMavenFileFilter;
import org.apache.maven.shared.filtering.DefaultMavenResourcesFiltering;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Singleton
@Named(value="mod-files")
public class ModFilesFiltering
extends DefaultMavenResourcesFiltering
implements MavenResourcesFiltering {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMavenResourcesFiltering.class);
    private static ThreadLocal<MavenProject> CURRENT_PROJECT = new ThreadLocal();

    public List<String> getDefaultNonFilteredFileExtensions() {
        return Collections.emptyList();
    }

    @Inject
    public ModFilesFiltering(MavenFileFilter mavenFileFilter, BuildContext buildContext) {
        super((MavenFileFilter)new JettyModFilesFileFilter(buildContext), buildContext);
    }

    public void filterResources(MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        CURRENT_PROJECT.set(mavenResourcesExecution.getMavenProject());
        super.filterResources(mavenResourcesExecution);
    }

    private static Optional<Dependency> findDependency(String groupId, String artifactId, List<Dependency> dependencies) {
        return dependencies.stream().filter(dependency -> groupId.equals(dependency.getGroupId()) && artifactId.equals(dependency.getArtifactId())).findFirst();
    }

    private static String dependencyToJarName(Dependency dependency) {
        return dependency.getArtifactId() + "-" + dependency.getVersion() + ".jar";
    }

    public static class JettyModFilesFileFilter
    extends DefaultMavenFileFilter
    implements MavenFileFilter {
        private BuildContext buildContext;

        @Inject
        public JettyModFilesFileFilter(BuildContext buildContext) {
            super(buildContext);
            this.buildContext = buildContext;
        }

        public void copyFile(File from, File to, boolean filtering, List<FilterWrapper> filterWrappers, String encoding, boolean overwrite) throws MavenFilteringException {
            MavenProject mavenProject = CURRENT_PROJECT.get();
            try {
                if (filtering && Files.exists(from.toPath(), new LinkOption[0])) {
                    String content = Files.readString(from.toPath());
                    StringLookup stringLookup = s -> {
                        if (s.contains(":")) {
                            String artifactId;
                            String[] parts = s.split(":");
                            String groupId = parts[0];
                            Optional<Dependency> dependency = ModFilesFiltering.findDependency(groupId, artifactId = parts[1], mavenProject.getDependencies());
                            if (dependency.isPresent()) {
                                return ModFilesFiltering.dependencyToJarName(dependency.get());
                            }
                            dependency = ModFilesFiltering.findDependency(groupId, artifactId, mavenProject.getDependencyManagement().getDependencies());
                            return ModFilesFiltering.dependencyToJarName(dependency.orElseThrow(() -> new NullPointerException("cannot find dependency " + groupId + ":" + artifactId + " for file " + String.valueOf(from))));
                        }
                        return mavenProject.getProperties().getProperty(s);
                    };
                    StringSubstitutor stringSubstitutor = new StringSubstitutor(stringLookup, "@", "@", '\\');
                    Files.writeString(to.toPath(), (CharSequence)stringSubstitutor.replace(content), StandardCharsets.UTF_8, new OpenOption[0]);
                    this.buildContext.refresh(to);
                }
            }
            catch (IOException e) {
                LOGGER.error("error copying file {} to {}", (Object)from, (Object)to);
                throw new MavenFilteringException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

