/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dash.m4e.eclipse.signing;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.dash.m4e.eclipse.signing.AbstractEclipseSigningMojo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChecksumMojo
extends AbstractEclipseSigningMojo {
    protected String inputFile;
    protected String outputFile;
    protected String unzipDir;
    protected String unpackPath;
    protected String artifactsXml;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!FileUtils.fileExists((String)this.unzipDir)) {
                this.info("creating directory to hold unzipped artifact");
                FileUtils.mkdir((String)this.unzipDir);
            }
            if (!FileUtils.fileExists((String)FileUtils.dirname((String)this.outputFile))) {
                this.info("creating directory to hold output");
                FileUtils.mkdir((String)FileUtils.dirname((String)this.outputFile));
            }
            ZipUnArchiver unzipper = new ZipUnArchiver(new File(this.inputFile));
            unzipper.extract("", new File(this.unzipDir));
            ZipUnArchiver unzipper2 = new ZipUnArchiver(new File(this.unzipDir + "/artifacts.jar"));
            unzipper2.extract("", new File(this.unzipDir));
            FileUtils.fileDelete((String)(this.unzipDir + "/artifacts.jar.pack.gz"));
            FileUtils.fileDelete((String)(this.unzipDir + "/content.jar.pack.gz"));
            this.insertPropertyAndMappingRules();
            List files = FileUtils.getFileNames((File)new File(this.unzipDir), (String)"**/*.jar", (String)"", (boolean)true);
            for (String filename : files) {
                this.info("Processing: " + filename);
                if (filename.endsWith("artifacts.jar") || filename.endsWith("content.jar")) continue;
                this.update(filename);
            }
            FileUtils.fileDelete((String)(this.unzipDir + "/artifacts.jar"));
            ZipArchiver zipper = new ZipArchiver();
            zipper.addFile(new File(this.unzipDir + "/artifacts.xml"), "artifacts.xml");
            zipper.setDestFile(new File(this.unzipDir + "/artifacts.jar"));
            zipper.createArchive();
            FileUtils.fileDelete((String)(this.unzipDir + "/artifacts.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void update(String plugin) {
        try {
            Node downloadMD5;
            Node downloadSize;
            boolean isPlugin = plugin.contains("/plugins/");
            String pluginFile = FileUtils.basename((String)plugin, (String)".jar");
            Pattern p = Pattern.compile("_\\d*\\.");
            String[] bits = p.split(pluginFile);
            int versionSplitUnderscore = bits[0].length();
            String[] artifactBits = new String[]{pluginFile.substring(0, versionSplitUnderscore), pluginFile.substring(versionSplitUnderscore + 1, pluginFile.length())};
            this.getLog().info((CharSequence)(" Artifact: " + artifactBits[0] + " / Version: " + artifactBits[1] + " / isPlugin: " + isPlugin));
            File inFile = new File(plugin);
            String inFileSize = Long.toString(inFile.length());
            int count = 0;
            byte[] buffer = new byte[16384];
            FileInputStream in = new FileInputStream(inFile);
            MessageDigest md = MessageDigest.getInstance("MD5");
            while ((count = ((InputStream)in).read(buffer)) > 0) {
                md.update(buffer, 0, count);
            }
            ((InputStream)in).close();
            String inFileMD5 = this.convert(md.digest());
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(this.artifactsXml));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expr = isPlugin ? "/repository/artifacts//artifact[@id='" + artifactBits[0] + "' and @version='" + artifactBits[1] + "' and @classifier='osgi.bundle']/properties//property[@name='artifact.size']/@value" : "/repository/artifacts//artifact[@id='" + artifactBits[0] + "' and @version='" + artifactBits[1] + "' and @classifier='org.eclipse.update.feature']/properties//property[@name='artifact.size']/@value";
            Node artifactSize = (Node)xpath.evaluate(expr, document, XPathConstants.NODE);
            if (artifactSize != null) {
                artifactSize.setNodeValue(inFileSize);
            }
            if ((downloadSize = (Node)xpath.evaluate(expr = isPlugin ? "/repository/artifacts//artifact[@id='" + artifactBits[0] + "' and @version='" + artifactBits[1] + "' and @classifier='osgi.bundle']/properties//property[@name='download.size']/@value" : "/repository/artifacts//artifact[@id='" + artifactBits[0] + "' and @version='" + artifactBits[1] + "' and @classifier='org.eclipse.update.feature']/properties//property[@name='download.size']/@value", document, XPathConstants.NODE)) != null) {
                downloadSize.setNodeValue(inFileSize);
            }
            if ((downloadMD5 = (Node)xpath.evaluate(expr = isPlugin ? "/repository/artifacts//artifact[@id='" + artifactBits[0] + "' and @version='" + artifactBits[1] + "' and @classifier='osgi.bundle']/properties//property[@name='download.md5']/@value" : "/repository/artifacts//artifact[@id='" + artifactBits[0] + "' and @version='" + artifactBits[1] + "' and @classifier='org.eclipse.update.feature']/properties//property[@name='download.md5']/@value", document, XPathConstants.NODE)) != null) {
                downloadMD5.setNodeValue(inFileMD5);
            }
            if (FileUtils.fileExists((String)(plugin + ".pack.gz"))) {
                File packFile = new File(plugin + ".pack.gz");
                String packFileSize = Long.toString(packFile.length());
                expr = "/repository/artifacts";
                Node normal = (Node)xpath.evaluate(expr, document, XPathConstants.NODE);
                Element packed = document.createElement("artifact");
                packed.setAttribute("classifier", isPlugin ? "osgi.bundle" : "org.eclipse.update.feature");
                packed.setAttribute("id", artifactBits[0]);
                packed.setAttribute("version", artifactBits[1]);
                Element processing = document.createElement("processing");
                processing.setAttribute("size", "1");
                packed.appendChild(processing);
                Element step = document.createElement("step");
                step.setAttribute("id", "org.eclipse.equinox.p2.processing.Pack200Unpacker");
                step.setAttribute("required", "true");
                processing.appendChild(step);
                Element properties = document.createElement("properties");
                properties.setAttribute("size", "3");
                packed.appendChild(properties);
                Element prop1 = document.createElement("property");
                prop1.setAttribute("name", "artifact.size");
                prop1.setAttribute("value", inFileSize);
                properties.appendChild(prop1);
                Element prop2 = document.createElement("property");
                prop2.setAttribute("name", "download.size");
                prop2.setAttribute("value", packFileSize);
                properties.appendChild(prop2);
                Element prop3 = document.createElement("property");
                prop3.setAttribute("name", "format");
                prop3.setAttribute("value", "packed");
                properties.appendChild(prop3);
                normal.appendChild(packed);
            }
            Transformer txformer = TransformerFactory.newInstance().newTransformer();
            DOMSource src = new DOMSource(document);
            StreamResult res = new StreamResult(this.artifactsXml);
            txformer.transform(src, res);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected void insertPropertyAndMappingRules() {
        try {
            Node firstRule;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(this.artifactsXml));
            boolean documentWasModified = false;
            String selectPublishPackfilesAsSiblings = "/repository/properties/property[@name='publishPackFilesAsSiblings']";
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element propertyEl = (Element)xpath.evaluate(selectPublishPackfilesAsSiblings, document, XPathConstants.NODE);
            String selectProperties = "/repository/properties";
            xpath = XPathFactory.newInstance().newXPath();
            Element propertiesEl = (Element)xpath.evaluate(selectProperties, document, XPathConstants.NODE);
            if (propertiesEl == null) {
                throw new IllegalArgumentException("The artifacts.xml document must have a /repository/properties element.");
            }
            if (propertyEl == null) {
                Element publishPackElem = document.createElement("property");
                publishPackElem.setAttribute("name", "publishPackFilesAsSiblings");
                publishPackElem.setAttribute("value", "true");
                propertiesEl.appendChild(publishPackElem);
                documentWasModified = true;
            } else if (!"true".equals(propertyEl.getAttribute("value"))) {
                propertyEl.setAttribute("value", "true");
                documentWasModified = true;
            }
            if (documentWasModified) {
                int size = propertiesEl.getElementsByTagName("property").getLength();
                propertiesEl.setAttribute("size", String.valueOf(size));
            }
            String selectMappings = "/repository/mappings";
            xpath = XPathFactory.newInstance().newXPath();
            Element mappingsEl = (Element)xpath.evaluate(selectMappings, document, XPathConstants.NODE);
            if (mappingsEl == null) {
                throw new IllegalArgumentException("The artifacts.xml document must have a /repository/mappings element.");
            }
            boolean foundPackedBundleFilter = false;
            boolean foundPackedFeatureFilter = false;
            NodeList nl = mappingsEl.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element rule;
                String filter;
                Node c = nl.item(i);
                if (c.getNodeType() != 1 || (filter = (rule = (Element)c).getAttribute("filter")).indexOf("format=packed") == -1) continue;
                if (filter.indexOf("classifier=osgi.bundle") != -1) {
                    foundPackedBundleFilter = true;
                } else if (filter.indexOf("classifier=org.eclipse.update.feature") != -1) {
                    foundPackedFeatureFilter = true;
                }
                if (foundPackedBundleFilter && foundPackedFeatureFilter) break;
            }
            if (!foundPackedBundleFilter) {
                Element ruleElem = document.createElement("rule");
                ruleElem.setAttribute("filter", "(& (classifier=osgi.bundle) (format=packed))");
                ruleElem.setAttribute("output", "${repoUrl}/plugins/${id}_${version}.jar.pack.gz");
                firstRule = mappingsEl.getFirstChild();
                mappingsEl.insertBefore(ruleElem, firstRule);
                documentWasModified = true;
            }
            if (!foundPackedFeatureFilter) {
                Element ruleElem = document.createElement("rule");
                ruleElem.setAttribute("filter", "(& (classifier=org.eclipse.update.feature) (format=packed))");
                ruleElem.setAttribute("output", "${repoUrl}/features/${id}_${version}.jar.pack.gz");
                firstRule = mappingsEl.getFirstChild();
                mappingsEl.insertBefore(ruleElem, firstRule);
                documentWasModified = true;
            }
            if (!foundPackedFeatureFilter || !foundPackedBundleFilter) {
                int size = mappingsEl.getElementsByTagName("rule").getLength();
                mappingsEl.setAttribute("size", String.valueOf(size));
            }
            if (documentWasModified) {
                Transformer txformer = TransformerFactory.newInstance().newTransformer();
                DOMSource src = new DOMSource(document);
                StreamResult res = new StreamResult(this.artifactsXml);
                txformer.transform(src, res);
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private String convert(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Character.forDigit(bytes[i] >> 4 & 0xF, 16));
            sb.append(Character.forDigit(bytes[i] & 0xF, 16));
        }
        return sb.toString();
    }

    private void info(String log) {
        this.getLog().info((CharSequence)("[FIX] " + log));
    }

    public static void main(String[] args) throws Exception {
        String file = "org.eclipse.equinox.server.core_1.1.1.R37x_v20110907-7K7TFBYDzbeA3ypK_98cDL15A4A";
        Pattern p = Pattern.compile("_\\d");
        String[] bits = p.split(file);
        System.out.println(file.substring(0, bits[0].length()) + " / " + file.substring(bits[0].length() + 1, file.length()));
    }
}

