/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.StandardStream;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.GoAwayResultInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;

public class ProxyHTTPSPDYConnection
extends HttpConnection
implements HttpParser.RequestHandler {
    private final short version;
    private final Fields headers = new Fields();
    private final ProxyEngineSelector proxyEngineSelector;
    private final ISession session;
    private HTTPStream stream;
    private ByteBuffer content;

    public ProxyHTTPSPDYConnection(Connector connector, HttpConfiguration config, EndPoint endPoint, short version, ProxyEngineSelector proxyEngineSelector) {
        super(config, connector, endPoint, true);
        this.version = version;
        this.proxyEngineSelector = proxyEngineSelector;
        this.session = new HTTPSession(version, connector);
    }

    protected HttpParser.RequestHandler newRequestHandler() {
        return this;
    }

    public boolean startRequest(String methodString, String uri, HttpVersion httpVersion) {
        Connector connector = this.getConnector();
        String scheme = connector.getConnectionFactory(SslConnectionFactory.class) != null ? "https" : "http";
        this.headers.put(HTTPSPDYHeader.SCHEME.name(this.version), scheme);
        this.headers.put(HTTPSPDYHeader.METHOD.name(this.version), methodString);
        this.headers.put(HTTPSPDYHeader.URI.name(this.version), uri.toString());
        this.headers.put(HTTPSPDYHeader.VERSION.name(this.version), httpVersion.asString());
        return false;
    }

    public void parsedHeader(HttpField field) {
        if (field.getHeader() == HttpHeader.HOST) {
            this.headers.put(HTTPSPDYHeader.HOST.name(this.version), field.getValue());
        } else {
            this.headers.put(field.getName(), field.getValue());
        }
    }

    public boolean headerComplete() {
        return false;
    }

    public boolean content(ByteBuffer item) {
        if (this.content == null) {
            this.stream = this.syn(false);
            this.content = item;
        } else {
            this.stream.getStreamFrameListener().onData((Stream)this.stream, this.toDataInfo(item, false));
        }
        return false;
    }

    public boolean messageComplete() {
        if (this.stream == null) {
            assert (this.content == null);
            if (this.headers.isEmpty()) {
                this.proxyEngineSelector.onGoAway((Session)this.session, new GoAwayResultInfo(0, SessionStatus.OK));
            } else {
                this.syn(true);
            }
        } else {
            this.stream.getStreamFrameListener().onData((Stream)this.stream, this.toDataInfo(this.content, true));
        }
        return false;
    }

    public void completed() {
        this.headers.clear();
        this.stream = null;
        this.content = null;
        super.completed();
    }

    public int getHeaderCacheSize() {
        return 256;
    }

    public void earlyEOF() {
    }

    public void badMessage(int status, String reason) {
    }

    private HTTPStream syn(boolean close) {
        HTTPStream stream = new HTTPStream(1, 0, this.session, null);
        StreamFrameListener streamFrameListener = this.proxyEngineSelector.onSyn((Stream)stream, new SynInfo(this.headers, close));
        stream.setStreamFrameListener(streamFrameListener);
        return stream;
    }

    private DataInfo toDataInfo(ByteBuffer buffer, boolean close) {
        return new ByteBufferDataInfo(buffer, close);
    }

    private void addPersistenceHeader(Fields headersToAddTo) {
        HttpVersion httpVersion = HttpVersion.fromString((String)this.headers.get("version").getValue());
        boolean persistent = false;
        switch (httpVersion) {
            case HTTP_1_0: {
                Fields.Field keepAliveHeader = this.headers.get(HttpHeader.KEEP_ALIVE.asString());
                if (keepAliveHeader != null) {
                    persistent = HttpHeaderValue.KEEP_ALIVE.asString().equals(keepAliveHeader.getValue());
                }
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this.headers.get("method").getValue());
                }
                if (!persistent) break;
                headersToAddTo.add(HttpHeader.CONNECTION.asString(), HttpHeaderValue.KEEP_ALIVE.asString());
                break;
            }
            case HTTP_1_1: {
                Fields.Field connectionHeader = this.headers.get(HttpHeader.CONNECTION.asString());
                persistent = connectionHeader != null ? !HttpHeaderValue.CLOSE.asString().equals(connectionHeader.getValue()) : true;
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this.headers.get("method").getValue());
                }
                if (persistent) break;
                headersToAddTo.add(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private class HTTPPushStream
    extends StandardStream {
        private HTTPPushStream(int id, byte priority, ISession session, IStream associatedStream) {
            super(id, priority, session, associatedStream, ProxyHTTPSPDYConnection.this.getHttpChannel().getScheduler(), null);
        }

        public void headers(HeadersInfo headersInfo, Callback handler) {
            handler.succeeded();
        }

        public void data(DataInfo dataInfo, Callback handler) {
            handler.succeeded();
        }
    }

    private class HTTPStream
    extends StandardStream {
        private final Pattern statusRegexp;

        private HTTPStream(int id, byte priority, ISession session, IStream associatedStream) {
            super(id, priority, session, associatedStream, ProxyHTTPSPDYConnection.this.getHttpChannel().getScheduler(), null);
            this.statusRegexp = Pattern.compile("(\\d{3})\\s+(.*)");
        }

        public void push(PushInfo pushInfo, Promise<Stream> handler) {
            handler.succeeded((Object)new HTTPPushStream(2, this.getPriority(), this.getSession(), (IStream)this));
        }

        public void headers(HeadersInfo headersInfo, Callback handler) {
            throw new UnsupportedOperationException("Not Yet Implemented");
        }

        public void reply(ReplyInfo replyInfo, final Callback handler) {
            Fields headers = new Fields(replyInfo.getHeaders(), false);
            ProxyHTTPSPDYConnection.this.addPersistenceHeader(headers);
            headers.remove(HTTPSPDYHeader.SCHEME.name(ProxyHTTPSPDYConnection.this.version));
            String status = headers.remove(HTTPSPDYHeader.STATUS.name(ProxyHTTPSPDYConnection.this.version)).getValue();
            Matcher matcher = this.statusRegexp.matcher(status);
            matcher.matches();
            int code = Integer.parseInt(matcher.group(1));
            String reason = matcher.group(2).trim();
            HttpVersion httpVersion = HttpVersion.fromString((String)headers.remove(HTTPSPDYHeader.VERSION.name(ProxyHTTPSPDYConnection.this.version)).getValue());
            Fields.Field host = headers.remove(HTTPSPDYHeader.HOST.name(ProxyHTTPSPDYConnection.this.version));
            if (host != null) {
                headers.put("host", host.getValue());
            }
            HttpFields fields = new HttpFields();
            for (Fields.Field header : headers) {
                String name = this.camelize(header.getName());
                fields.put(name, header.getValue());
            }
            long contentLength = fields.getLongField(HttpHeader.CONTENT_LENGTH.asString());
            MetaData.Response info = new MetaData.Response(httpVersion, code, reason, fields, contentLength);
            ProxyHTTPSPDYConnection.this.send(info, false, null, replyInfo.isClose(), (Callback)new Callback.Adapter(){

                public void failed(Throwable x) {
                    handler.failed(x);
                }
            });
            if (replyInfo.isClose()) {
                ProxyHTTPSPDYConnection.this.completed();
            }
            handler.succeeded();
        }

        private String camelize(String name) {
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                int j = i + 1;
                if (c != '-' || j >= chars.length) continue;
                chars[j] = Character.toUpperCase(chars[j]);
            }
            return new String(chars);
        }

        public void data(DataInfo dataInfo, final Callback handler) {
            ByteBuffer byteBuffer = dataInfo.asByteBuffer(false);
            ProxyHTTPSPDYConnection.this.send(null, false, byteBuffer, dataInfo.isClose(), (Callback)new Callback.Adapter(){

                public void failed(Throwable x) {
                    handler.failed(x);
                }
            });
            if (dataInfo.isClose()) {
                ProxyHTTPSPDYConnection.this.completed();
            }
            handler.succeeded();
        }
    }

    private class HTTPSession
    extends StandardSession {
        private HTTPSession(short version, Connector connector) {
            super(version, connector.getByteBufferPool(), connector.getScheduler(), null, ProxyHTTPSPDYConnection.this.getEndPoint(), null, 1, (SessionFrameListener)ProxyHTTPSPDYConnection.this.proxyEngineSelector, null, null);
        }

        public void rst(RstInfo rstInfo, Callback handler) {
            MetaData.Response info = new MetaData.Response(HttpVersion.fromString((String)ProxyHTTPSPDYConnection.this.headers.get("version").getValue()), 502, "SPDY reset received from upstream server", null, 0L);
            ProxyHTTPSPDYConnection.this.send(info, false, null, true, (Callback)Callback.Adapter.INSTANCE);
        }

        public void goAway(GoAwayInfo goAwayInfo, Callback handler) {
            ProxyHTTPSPDYConnection.this.close();
            handler.succeeded();
        }
    }
}

