/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.util.Fields;

public abstract class ProxyEngine {
    private static final Set<String> HOP_HEADERS = new HashSet<String>();
    private final String name;

    protected ProxyEngine() {
        this(ProxyEngine.name());
    }

    private static String name() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            return "localhost";
        }
    }

    public abstract StreamFrameListener proxy(Stream var1, SynInfo var2, ProxyEngineSelector.ProxyServerInfo var3);

    protected ProxyEngine(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void removeHopHeaders(Fields headers) {
        for (String hopHeader : HOP_HEADERS) {
            headers.remove(hopHeader);
        }
    }

    protected void addRequestProxyHeaders(Stream stream, Fields headers) {
        InetSocketAddress address;
        this.addViaHeader(headers);
        Fields.Field schemeField = headers.get(HTTPSPDYHeader.SCHEME.name(stream.getSession().getVersion()));
        if (schemeField != null) {
            headers.add("X-Forwarded-Proto", schemeField.value());
        }
        if ((address = stream.getSession().getRemoteAddress()) != null) {
            headers.add("X-Forwarded-Host", address.getHostName());
            headers.add("X-Forwarded-For", address.toString());
        }
        headers.add("X-Forwarded-Server", ProxyEngine.name());
    }

    protected void addResponseProxyHeaders(Stream stream, Fields headers) {
        this.addViaHeader(headers);
    }

    private void addViaHeader(Fields headers) {
        headers.add("Via", "http/1.1 " + this.getName());
    }

    protected void customizeRequestHeaders(Stream stream, Fields headers) {
    }

    protected void customizeResponseHeaders(Stream stream, Fields headers) {
    }

    static {
        HOP_HEADERS.add("proxy-connection");
        HOP_HEADERS.add("connection");
        HOP_HEADERS.add("keep-alive");
        HOP_HEADERS.add("transfer-encoding");
        HOP_HEADERS.add("te");
        HOP_HEADERS.add("trailer");
        HOP_HEADERS.add("proxy-authorization");
        HOP_HEADERS.add("proxy-authenticate");
        HOP_HEADERS.add("upgrade");
    }
}

