/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.server.SPDYServerConnectionFactory;
import org.eclipse.jetty.spdy.server.http.HttpChannelOverSPDY;
import org.eclipse.jetty.spdy.server.http.HttpInputOverSPDY;
import org.eclipse.jetty.spdy.server.http.HttpTransportOverSPDY;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTPSPDYServerConnectionFactory
extends SPDYServerConnectionFactory
implements HttpConfiguration.ConnectionFactory {
    private static final String CHANNEL_ATTRIBUTE = "org.eclipse.jetty.spdy.server.http.HTTPChannelOverSPDY";
    private static final Logger logger = Log.getLogger(HTTPSPDYServerConnectionFactory.class);
    private final PushStrategy pushStrategy;
    private final HttpConfiguration httpConfiguration;

    public HTTPSPDYServerConnectionFactory(@Name(value="version") int version, @Name(value="config") HttpConfiguration config) {
        this(version, config, new PushStrategy.None());
    }

    public HTTPSPDYServerConnectionFactory(@Name(value="version") int version, @Name(value="config") HttpConfiguration config, @Name(value="pushStrategy") PushStrategy pushStrategy) {
        super(version);
        this.pushStrategy = pushStrategy;
        this.httpConfiguration = config;
        this.addBean(this.httpConfiguration);
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    protected ServerSessionFrameListener provideServerSessionFrameListener(Connector connector, EndPoint endPoint) {
        return new HTTPServerFrameListener(connector, endPoint);
    }

    private class HTTPServerFrameListener
    extends ServerSessionFrameListener.Adapter
    implements StreamFrameListener {
        private final Connector connector;
        private final EndPoint endPoint;

        public HTTPServerFrameListener(Connector connector, EndPoint endPoint) {
            this.endPoint = endPoint;
            this.connector = connector;
        }

        public StreamFrameListener onSyn(Stream stream, SynInfo synInfo) {
            logger.debug("Received {} on {}", new Object[]{synInfo, stream});
            Fields headers = synInfo.getHeaders();
            HttpTransportOverSPDY transport = new HttpTransportOverSPDY(this.connector, HTTPSPDYServerConnectionFactory.this.httpConfiguration, this.endPoint, HTTPSPDYServerConnectionFactory.this.pushStrategy, stream, headers);
            HttpInputOverSPDY input = new HttpInputOverSPDY();
            HttpChannelOverSPDY channel = new HttpChannelOverSPDY(this.connector, HTTPSPDYServerConnectionFactory.this.httpConfiguration, this.endPoint, transport, input, stream);
            stream.setAttribute(HTTPSPDYServerConnectionFactory.CHANNEL_ATTRIBUTE, (Object)channel);
            channel.requestStart(headers, synInfo.isClose());
            if (headers.isEmpty()) {
                return this;
            }
            if (synInfo.isClose()) {
                return null;
            }
            return this;
        }

        public void onReply(Stream stream, ReplyInfo replyInfo) {
        }

        public void onHeaders(Stream stream, HeadersInfo headersInfo) {
            logger.debug("Received {} on {}", new Object[]{headersInfo, stream});
            HttpChannelOverSPDY channel = (HttpChannelOverSPDY)((Object)stream.getAttribute(HTTPSPDYServerConnectionFactory.CHANNEL_ATTRIBUTE));
            channel.requestHeaders(headersInfo.getHeaders(), headersInfo.isClose());
        }

        public StreamFrameListener onPush(Stream stream, PushInfo pushInfo) {
            return null;
        }

        public void onData(Stream stream, DataInfo dataInfo) {
            logger.debug("Received {} on {}", new Object[]{dataInfo, stream});
            HttpChannelOverSPDY channel = (HttpChannelOverSPDY)((Object)stream.getAttribute(HTTPSPDYServerConnectionFactory.CHANNEL_ATTRIBUTE));
            channel.requestContent(dataInfo, dataInfo.isClose());
        }
    }
}

