/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelConfig;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.http.HttpInputOverSPDY;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpChannelOverSPDY
extends HttpChannel<DataInfo> {
    private static final Logger LOG = Log.getLogger(HttpChannelOverSPDY.class);
    private final Queue<Runnable> tasks = new LinkedList<Runnable>();
    private final Stream stream;
    private boolean dispatched;
    private boolean headersComplete;

    public HttpChannelOverSPDY(Connector connector, HttpChannelConfig configuration, EndPoint endPoint, HttpTransport transport, HttpInputOverSPDY input, Stream stream) {
        super(connector, configuration, endPoint, transport, (HttpInput)input);
        this.stream = stream;
    }

    public boolean headerComplete() {
        this.headersComplete = true;
        return super.headerComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(Runnable task) {
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            LOG.debug("Posting task {}", new Object[]{task});
            this.tasks.offer(task);
            this.dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            if (this.dispatched) {
                return;
            }
            final Runnable task = this.tasks.poll();
            if (task != null) {
                this.dispatched = true;
                LOG.debug("Dispatching task {}", new Object[]{task});
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        LOG.debug("Executing task {}", new Object[]{task});
                        task.run();
                        LOG.debug("Completing task {}", new Object[]{task});
                        HttpChannelOverSPDY.this.dispatched = false;
                        HttpChannelOverSPDY.this.dispatch();
                    }
                });
            }
        }
    }

    public void requestStart(Fields headers, boolean endRequest) {
        if (!headers.isEmpty()) {
            this.requestHeaders(headers, endRequest);
        }
    }

    public void requestHeaders(Fields headers, boolean endRequest) {
        boolean proceed = this.performBeginRequest(headers);
        if (!proceed) {
            return;
        }
        this.performHeaders(headers);
        if (endRequest) {
            if (this.headerComplete()) {
                this.post((Runnable)((Object)this));
            }
            if (this.messageComplete(-1L)) {
                this.post((Runnable)((Object)this));
            }
        }
    }

    public void requestContent(final DataInfo dataInfo, boolean endRequest) {
        if (!this.headersComplete && this.headerComplete()) {
            this.post((Runnable)((Object)this));
        }
        LOG.debug("HTTP > {} bytes of content", new Object[]{dataInfo.length()});
        ByteBuffer copyByteBuffer = dataInfo.asByteBuffer(false);
        ByteBufferDataInfo copyDataInfo = new ByteBufferDataInfo(copyByteBuffer, dataInfo.isClose(), dataInfo.isCompress()){

            public void consume(int delta) {
                super.consume(delta);
                dataInfo.consume(delta);
            }
        };
        LOG.debug("Queuing last={} content {}", new Object[]{endRequest, copyDataInfo});
        if (this.content(copyDataInfo)) {
            this.post((Runnable)((Object)this));
        }
        if (endRequest && this.messageComplete(-1L)) {
            this.post((Runnable)((Object)this));
        }
    }

    private boolean performBeginRequest(Fields headers) {
        short version = this.stream.getSession().getVersion();
        Fields.Field methodHeader = headers.get(HTTPSPDYHeader.METHOD.name(version));
        Fields.Field uriHeader = headers.get(HTTPSPDYHeader.URI.name(version));
        Fields.Field versionHeader = headers.get(HTTPSPDYHeader.VERSION.name(version));
        if (methodHeader == null || uriHeader == null || versionHeader == null) {
            this.badMessage(400, "Missing required request line elements");
            return false;
        }
        HttpMethod httpMethod = HttpMethod.fromString((String)methodHeader.value());
        HttpVersion httpVersion = HttpVersion.fromString((String)versionHeader.value());
        String uriString = uriHeader.value();
        LOG.debug("HTTP > {} {} {}", new Object[]{httpMethod, uriString, httpVersion});
        this.startRequest(httpMethod, httpMethod.asString(), uriString, httpVersion);
        Fields.Field schemeHeader = headers.get(HTTPSPDYHeader.SCHEME.name(version));
        if (schemeHeader != null) {
            this.getRequest().setScheme(schemeHeader.value());
        }
        return true;
    }

    private void performHeaders(Fields headers) {
        block9: for (Fields.Field header : headers) {
            String name = header.name();
            HttpHeader httpHeader = (HttpHeader)HttpHeader.CACHE.get(name);
            HTTPSPDYHeader specialHeader = HTTPSPDYHeader.from(this.stream.getSession().getVersion(), name);
            if (specialHeader != null) {
                if (specialHeader != HTTPSPDYHeader.HOST) continue;
                name = "host";
            }
            switch (name) {
                case "connection": 
                case "keep-alive": 
                case "proxy-connection": 
                case "transfer-encoding": {
                    continue block9;
                }
            }
            String value = header.value();
            LOG.debug("HTTP > {}: {}", new Object[]{name, value});
            this.parsedHeader(httpHeader, name, value);
        }
    }
}

