/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.spdy.client.SPDYClient;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NPNClientConnection
extends AbstractConnection
implements NextProtoNego.ClientProvider {
    private final Logger LOG = Log.getLogger(((Object)((Object)this)).getClass());
    private final SPDYClient client;
    private final ClientConnectionFactory connectionFactory;
    private final SSLEngine engine;
    private final Map<String, Object> context;
    private volatile boolean completed;

    public NPNClientConnection(EndPoint endPoint, SPDYClient client, ClientConnectionFactory connectionFactory, SSLEngine sslEngine, Map<String, Object> context) {
        super(endPoint, client.getFactory().getExecutor());
        this.client = client;
        this.connectionFactory = connectionFactory;
        this.engine = sslEngine;
        this.context = context;
        NextProtoNego.put((SSLEngine)this.engine, (NextProtoNego.Provider)this);
    }

    public void onOpen() {
        super.onOpen();
        try {
            this.getEndPoint().flush(new ByteBuffer[]{BufferUtil.EMPTY_BUFFER});
            if (this.completed) {
                this.replaceConnection();
            } else {
                this.fillInterested();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public void onFillable() {
        int filled;
        do {
            if ((filled = this.fill()) != 0 || this.completed) continue;
            this.fillInterested();
        } while (filled > 0 && !this.completed);
        if (this.completed) {
            this.replaceConnection();
        }
    }

    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            this.LOG.debug((Throwable)x);
            NextProtoNego.remove((SSLEngine)this.engine);
            this.close();
            return -1;
        }
    }

    public boolean supports() {
        return true;
    }

    public void unsupported() {
        NextProtoNego.remove((SSLEngine)this.engine);
        this.completed = true;
    }

    public String selectProtocol(List<String> protocols) {
        NextProtoNego.remove((SSLEngine)this.engine);
        this.completed = true;
        return this.client.selectProtocol(protocols);
    }

    private void replaceConnection() {
        EndPoint endPoint = this.getEndPoint();
        try {
            Connection oldConnection = endPoint.getConnection();
            Connection newConnection = this.connectionFactory.newConnection(endPoint, this.context);
            ClientConnectionFactory.Helper.replaceConnection((Connection)oldConnection, (Connection)newConnection);
        }
        catch (Throwable x) {
            this.LOG.debug(x);
            this.close();
        }
    }
}

