/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.internal.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.StreamsBlockedFrame;
import org.eclipse.jetty.quic.util.VarLenInt;

public class StreamsBlockedParser {
    private final VarLenInt varLenInt;
    private State state = State.FRAME_TYPE;
    private boolean bidirectional;
    private long maxStreams;

    public StreamsBlockedParser(VarLenInt varLenInt) {
        this.varLenInt = varLenInt;
    }

    public StreamsBlockedFrame parse(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.bidirectional = (byteBuffer.get() & 0xFF) == 22;
                    this.state = State.MAX_STREAMS;
                    break;
                }
                case 1: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.maxStreams = v;
                    })) break;
                    return this.result();
                }
            }
        }
        return null;
    }

    private StreamsBlockedFrame result() {
        StreamsBlockedFrame frame = new StreamsBlockedFrame(this.bidirectional, this.maxStreams);
        this.state = State.FRAME_TYPE;
        this.bidirectional = false;
        this.maxStreams = 0L;
        return frame;
    }

    private static enum State {
        FRAME_TYPE,
        MAX_STREAMS;

    }
}

