/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

public class StreamId {
    public static final long MAX_PROGRESSIVE = 0xFFFFFFFFFFFFFFFL;
    private static final long UNI_MASK = 2L;
    private static final long SERVER_MASK = 1L;

    public static int type(long streamId) {
        return (int)(streamId & 3L);
    }

    public static long progressive(long streamId) {
        return streamId >>> 2;
    }

    public static boolean exceedsMaxProgressive(long streamId) {
        return StreamId.progressive(streamId) > 0xFFFFFFFFFFFFFFFL;
    }

    public static boolean isBidirectional(long streamId) {
        return (streamId & 2L) == 0L;
    }

    public static long newStreamId(long progressive, boolean bidirectional, boolean client) {
        if (progressive > 0xFFFFFFFFFFFFFFFL) {
            return -1L;
        }
        long streamId = progressive << 2;
        if (!bidirectional) {
            streamId |= 2L;
        }
        if (!client) {
            streamId |= 1L;
        }
        return streamId;
    }

    public static boolean isLocal(long streamId, boolean client) {
        boolean server = (streamId & 1L) == 1L;
        return server && !client || !server && client;
    }

    private StreamId() {
    }
}

