/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.common.AbstractSession;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtocolSession
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolSession.class);
    private final ConcurrentMap<Long, StreamEndPoint> endPoints = new ConcurrentHashMap<Long, StreamEndPoint>();
    private final Executor executor;
    private final ByteBufferPool byteBufferPool;
    private final Session session;

    public ProtocolSession(Executor executor, ByteBufferPool byteBufferPool, Session session) {
        this.executor = executor;
        this.byteBufferPool = byteBufferPool;
        this.session = session;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public Session getSession() {
        return this.session;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.onStart();
    }

    protected void onStart() {
    }

    protected void doStop() throws Exception {
        this.onStop();
        super.doStop();
    }

    protected void onStop() {
    }

    private StreamEndPoint newStreamEndPoint(Stream stream) {
        return new StreamEndPoint(this, stream);
    }

    public StreamEndPoint getStreamEndPoint(long streamId) {
        return (StreamEndPoint)this.endPoints.get(streamId);
    }

    public StreamEndPoint createStreamEndPoint(Stream stream, Consumer<StreamEndPoint> initializer) {
        long streamId = stream.getId();
        StreamEndPoint streamEndPoint = this.endPoints.compute(streamId, (k, v) -> {
            if (v != null) {
                throw new IllegalStateException("duplicate stream " + streamId);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("creating endpoint for stream #{} for {}", (Object)streamId, (Object)this);
            }
            return this.newStreamEndPoint(stream);
        });
        initializer.accept(streamEndPoint);
        return streamEndPoint;
    }

    public boolean removeStreamEndPoint(StreamEndPoint endPoint) {
        boolean removed;
        boolean bl = removed = this.endPoints.remove(endPoint.getStream().getId()) != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed {} {} from {}", new Object[]{removed, endPoint, this});
        }
        return removed;
    }

    public Collection<StreamEndPoint> getStreamEndPoints() {
        return this.endPoints.values();
    }

    public void openStreamEndPoint(StreamEndPoint endPoint) {
        try {
            Connection connection = this.newConnection(endPoint);
            endPoint.setConnection(connection);
            endPoint.onOpen();
            connection.onOpen();
        }
        catch (Error | RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private void closeStreamEndPoint(StreamEndPoint endPoint, Throwable failure) {
        Connection connection = endPoint.getConnection();
        if (connection != null) {
            connection.close();
        } else {
            endPoint.close(failure);
        }
    }

    protected abstract Connection newConnection(StreamEndPoint var1) throws IOException;

    public CompletableFuture<ProtocolSession> shutdown() {
        CompletableFuture<ProtocolSession> completable = new CompletableFuture<ProtocolSession>();
        this.disconnect(new ConnectionCloseFrame(ErrorCode.NO_ERROR.code(), "shutdown"), null, (Promise.Invocable<ProtocolSession>)Promise.Invocable.toPromise(completable));
        return completable;
    }

    public boolean onIdleTimeout(TimeoutException timeout) {
        return true;
    }

    public void onStreamFailure(long streamId, Throwable failure) {
        StreamEndPoint streamEndPoint = this.getStreamEndPoint(streamId);
        if (streamEndPoint != null) {
            streamEndPoint.disconnect(ErrorCode.NO_ERROR.code(), failure, true, (Promise.Invocable<StreamEndPoint>)Promise.Invocable.noop());
        }
    }

    public void close(ConnectionCloseFrame frame, Promise.Invocable<ProtocolSession> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("session closed locally {} {}", (Object)frame, (Object)this);
        }
        this.closeAndDisconnect(frame, promise);
    }

    public void onClose(ConnectionCloseFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("session closed remotely {} {}", (Object)frame, (Object)this);
        }
        this.closeAndDisconnect(frame, (Promise.Invocable<ProtocolSession>)Promise.Invocable.noop());
    }

    private void closeAndDisconnect(ConnectionCloseFrame frame, Promise.Invocable<ProtocolSession> promise) {
        for (StreamEndPoint streamEndPoint : this.getStreamEndPoints()) {
            this.closeStreamEndPoint(streamEndPoint, null);
        }
        this.disconnect(frame, null, promise);
    }

    public void disconnect(ConnectionCloseFrame frame, Throwable failure, Promise.Invocable<ProtocolSession> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("disconnecting with {} on {}", (Object)frame, (Object)this);
        }
        for (StreamEndPoint streamEndPoint : this.getStreamEndPoints()) {
            streamEndPoint.disconnect(frame.getErrorCode(), failure, false, (Promise.Invocable<StreamEndPoint>)Promise.Invocable.noop());
        }
        this.getSession().disconnect(frame, failure, Promise.Invocable.toPromise(promise, s -> this));
    }

    public void offerTask(Runnable task, boolean dispatch) {
        if (task == null) {
            return;
        }
        AbstractSession session = (AbstractSession)this.getSession();
        session.offerTask(task, dispatch);
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("streamEndPoints", this.getStreamEndPoints())});
    }

    public static interface Factory {
        public ProtocolSession newProtocolSession(Session var1, Map<String, Object> var2);
    }
}

