/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.api.frames.DataBlockedFrame;
import org.eclipse.jetty.quic.api.frames.MaxDataFrame;
import org.eclipse.jetty.quic.api.frames.MaxStreamsFrame;
import org.eclipse.jetty.quic.api.frames.StreamsBlockedFrame;
import org.eclipse.jetty.quic.api.frames.TransportParameters;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSession
extends ContainerLifeCycle
implements Session {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSession.class);
    private final Executor executor;
    private final QuicConfiguration configuration;
    private final Session.Listener listener;

    protected AbstractSession(Executor executor, QuicConfiguration configuration, Session.Listener listener) {
        this.executor = executor;
        this.configuration = configuration;
        this.listener = listener;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public QuicConfiguration getQuicConfiguration() {
        return this.configuration;
    }

    public Session.Listener getListener() {
        return this.listener;
    }

    public abstract X509Certificate[] getPeerCertificates();

    protected void emitOpen() {
        this.notifyOpen();
        this.configuration.getEventListeners().stream().filter(l -> l instanceof Session.Listener).map(Session.Listener.class::cast).forEach(this::notifyOpen);
    }

    protected void emitDisconnect() {
        this.notifyDisconnect();
        this.configuration.getEventListeners().stream().filter(l -> l instanceof Session.Listener).map(Session.Listener.class::cast).forEach(this::notifyDisconnect);
    }

    public abstract void offerTask(Runnable var1, boolean var2);

    public CompletableFuture<Session> shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shutdown {}", (Object)this);
        }
        return this.notifyLocalShutdown();
    }

    public void close(ConnectionCloseFrame frame, Promise.Invocable<Session> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("closing {} {}", (Object)frame, (Object)this);
        }
        this.notifyLocalClose(frame, promise);
    }

    protected void notifyOpen() {
        this.notifyOpen(this.listener);
    }

    private void notifyOpen(Session.Listener listener) {
        try {
            listener.onOpen((Session)this);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    protected Stream.Listener notifyNewStream() {
        try {
            return this.listener.onNewStream((Session)this, null);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
            return null;
        }
    }

    protected TransportParameters notifyPrepare() {
        try {
            return this.listener.onPrepare((Session)this);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
            return null;
        }
    }

    protected void notifyTransportParameters(TransportParameters parameters) {
        block2: {
            try {
                this.listener.onTransportParameters((Session)this, parameters);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
        }
    }

    protected void notifyMaxStreams(MaxStreamsFrame frame) {
        block2: {
            try {
                this.listener.onMaxStreams((Session)this, frame);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
        }
    }

    protected void notifyDataBlocked(DataBlockedFrame frame) {
        block2: {
            try {
                this.listener.onDataBlocked((Session)this, frame);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
        }
    }

    protected void notifyMaxData(MaxDataFrame frame) {
        block2: {
            try {
                this.listener.onMaxData((Session)this, frame);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
        }
    }

    protected void notifyPing() {
        block2: {
            try {
                this.listener.onPing((Session)this);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
        }
    }

    protected void notifyStreamsBlocked(StreamsBlockedFrame frame) {
        block2: {
            try {
                this.listener.onStreamsBlocked((Session)this, frame);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
        }
    }

    private CompletableFuture<Session> notifyLocalShutdown() {
        try {
            Session.Listener listener = this.listener;
            if (listener instanceof Listener) {
                Listener extended = (Listener)listener;
                return extended.onLocalShutdown(this);
            }
            return CompletableFuture.completedFuture(this);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
            return CompletableFuture.failedFuture(x);
        }
    }

    protected boolean notifyIdleTimeout(TimeoutException failure) {
        try {
            return this.listener.onIdleTimeout((Session)this, failure);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
            return true;
        }
    }

    protected void notifyLocalClose(ConnectionCloseFrame frame, Promise.Invocable<Session> promise) {
        try {
            Session.Listener listener = this.listener;
            if (listener instanceof Listener) {
                Listener extended = (Listener)listener;
                extended.onLocalClose(this, frame, promise);
            } else {
                promise.succeeded((Object)this);
            }
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
            promise.failed(x);
        }
    }

    protected void notifyClose(ConnectionCloseFrame frame) {
        block2: {
            try {
                this.listener.onClose((Session)this, frame);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
            }
        }
    }

    protected void notifyDisconnect() {
        this.notifyDisconnect(this.listener);
    }

    private void notifyDisconnect(Session.Listener listener) {
        try {
            listener.onDisconnect((Session)this);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public String toString() {
        return "%s@%x".formatted(TypeUtil.toShortName(((Object)((Object)this)).getClass()), ((Object)((Object)this)).hashCode());
    }

    public static interface Listener
    extends Session.Listener {
        public CompletableFuture<Session> onLocalShutdown(Session var1);

        public void onLocalClose(Session var1, ConnectionCloseFrame var2, Promise.Invocable<Session> var3);
    }
}

