/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.ProtocolStreamListener;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProtocolSession
extends ProtocolSession {
    private static final Logger LOG = LoggerFactory.getLogger(ClientProtocolSession.class);
    private final ClientConnectionFactory connectionFactory;
    private final Map<String, Object> context;

    public ClientProtocolSession(ClientConnector clientConnector, Session session, ClientConnectionFactory connectionFactory, Map<String, Object> context) {
        super(clientConnector.getExecutor(), clientConnector.getByteBufferPool(), session);
        this.connectionFactory = connectionFactory;
        this.context = context;
    }

    protected void onStart() {
        try {
            long streamId = this.getSession().newStreamId(true);
            AtomicReference<StreamEndPoint> endPointRef = new AtomicReference<StreamEndPoint>();
            Stream stream = this.getSession().newStream(streamId, (Stream.Listener)new ProtocolStreamListener.Client(endPointRef::get));
            endPointRef.set(this.createStreamEndPoint(stream, arg_0 -> ((ClientProtocolSession)this).openStreamEndPoint(arg_0)));
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not create stream", x);
            }
            ConnectionCloseFrame disconnect = new ConnectionCloseFrame(ErrorCode.INTERNAL_ERROR.code(), "start_failure");
            this.disconnect(disconnect, x, Promise.Invocable.noop());
        }
    }

    protected Connection newConnection(StreamEndPoint endPoint) throws IOException {
        return this.connectionFactory.newConnection((EndPoint)endPoint, this.context);
    }
}

