/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.api.frames;

import org.eclipse.jetty.quic.api.frames.Frame;

public class NewConnectionIdFrame
extends Frame {
    private final byte[] connectionId;
    private final long sequenceNumber;
    private final long retirePriorTo;
    private final byte[] resetToken;

    public NewConnectionIdFrame(byte[] connectionId, long sequenceNumber, long retirePriorTo, byte[] resetToken) {
        super(24L);
        if (connectionId.length < 1 || connectionId.length > 20) {
            throw new IllegalArgumentException("invalid_connection_id");
        }
        this.connectionId = connectionId;
        this.sequenceNumber = sequenceNumber;
        this.retirePriorTo = retirePriorTo;
        if (resetToken.length != 16) {
            throw new IllegalArgumentException("invalid_reset_token");
        }
        this.resetToken = resetToken;
    }

    public byte[] getConnectionId() {
        return this.connectionId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getRetirePriorTo() {
        return this.retirePriorTo;
    }

    public byte[] getResetToken() {
        return this.resetToken;
    }
}

