/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.api;

import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.frames.Frame;
import org.eclipse.jetty.quic.api.frames.ResetFrame;
import org.eclipse.jetty.quic.api.frames.StopSendingFrame;
import org.eclipse.jetty.quic.api.frames.StreamDataBlockedFrame;
import org.eclipse.jetty.quic.api.frames.StreamMaxDataFrame;
import org.eclipse.jetty.util.Promise;

public interface Stream {
    public long getId();

    public boolean isBidirectional();

    public boolean isLocal();

    public boolean isClosed();

    public boolean isLocallyClosed();

    public boolean isRemotelyClosed();

    public long getIdleTimeout();

    public void setIdleTimeout(long var1);

    public Session getSession();

    public Content.Chunk read();

    public void demand();

    public void data(boolean var1, List<ByteBuffer> var2, Promise.Invocable<Stream> var3);

    public void maxData(long var1, Promise.Invocable<Stream> var3);

    public void reset(long var1, Promise.Invocable<Stream> var3);

    public void stopSending(long var1, Promise.Invocable<Stream> var3);

    public void dataBlocked(long var1, Promise.Invocable<Stream> var3);

    public void disconnect(long var1, Throwable var3, Promise.Invocable<Stream> var4);

    public static interface Listener
    extends EventListener {
        default public void onNewStream(Stream stream, Frame.WithStreamId frame) {
            stream.demand();
        }

        default public void onDataAvailable(Stream stream) {
            Content.Chunk chunk;
            do {
                if ((chunk = stream.read()) == null) {
                    stream.demand();
                    return;
                }
                chunk.release();
            } while (!chunk.isLast());
        }

        default public void onDataBlocked(Stream stream, StreamDataBlockedFrame frame) {
        }

        default public void onMaxData(Stream stream, StreamMaxDataFrame frame) {
        }

        default public void onStopSending(Stream stream, StopSendingFrame frame) {
        }

        default public void onReset(Stream stream, ResetFrame frame) {
        }

        default public void onClose(Stream stream) {
        }

        default public void onIdleTimeout(Stream stream, TimeoutException failure, Promise.Invocable<Boolean> promise) {
            promise.succeeded((Object)true);
        }

        default public void onFailure(Stream stream, Throwable failure) {
        }
    }
}

