/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import org.eclipse.jetty.osgi.boot.internal.serverfactory.DefaultJettyAtJettyHomeHelper;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.JettyServerServiceTracker;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class JettyBootstrapActivator
implements BundleActivator {
    private static final Logger LOG = Log.getLogger(JettyBootstrapActivator.class);
    private static JettyBootstrapActivator INSTANCE = null;
    private ServiceRegistration _registeredServer;
    private PackageAdminServiceTracker _packageAdminServiceTracker;
    private ServiceTracker _jettyServerServiceTracker;

    public static JettyBootstrapActivator getInstance() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        this._packageAdminServiceTracker = new PackageAdminServiceTracker(context);
        this._jettyServerServiceTracker = new ServiceTracker(context, context.createFilter("(objectclass=" + Server.class.getName() + ")"), (ServiceTrackerCustomizer)new JettyServerServiceTracker());
        this._jettyServerServiceTracker.open();
        DefaultJettyAtJettyHomeHelper.startJettyAtJettyHome(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        block8: {
            try {
                if (this._jettyServerServiceTracker != null) {
                    this._jettyServerServiceTracker.close();
                    this._jettyServerServiceTracker = null;
                }
                if (this._packageAdminServiceTracker != null) {
                    this._packageAdminServiceTracker.stop();
                    context.removeServiceListener((ServiceListener)this._packageAdminServiceTracker);
                    this._packageAdminServiceTracker = null;
                }
                if (this._registeredServer == null) break block8;
                try {
                    this._registeredServer.unregister();
                    this._registeredServer = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this._registeredServer = null;
                }
                catch (Throwable throwable) {
                    this._registeredServer = null;
                    throw throwable;
                }
            }
            finally {
                INSTANCE = null;
            }
        }
    }
}

