/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jetty.osgi.boot.BundleProvider;
import org.eclipse.jetty.osgi.boot.utils.TldBundleDiscoverer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;

public class BundleWatcher
implements BundleTrackerCustomizer {
    private static final Logger LOG = Log.getLogger(BundleWatcher.class);
    public static final Collection<TldBundleDiscoverer> JSP_REGISTRATION_HELPERS = new ArrayList<TldBundleDiscoverer>();
    public static final String FILTER = "(objectclass=" + BundleProvider.class.getName() + ")";
    private ServiceTracker _serviceTracker;
    private BundleTracker _bundleTracker;
    private boolean _waitForDefaultServer = true;
    private boolean _defaultServerReady = false;
    private Bundle _bundle = FrameworkUtil.getBundle(this.getClass());

    public BundleWatcher() throws Exception {
        this._serviceTracker = new ServiceTracker(this._bundle.getBundleContext(), FrameworkUtil.createFilter((String)FILTER), null);
        this._serviceTracker.open();
    }

    public boolean isWaitForDefaultServer() {
        return this._waitForDefaultServer;
    }

    public void setWaitForDefaultServer(boolean waitForDefaultServer) {
        this._waitForDefaultServer = waitForDefaultServer;
    }

    public void setBundleTracker(BundleTracker bundleTracker) {
        this._bundleTracker = bundleTracker;
    }

    public void open() throws Exception {
        if (this._waitForDefaultServer && !this._defaultServerReady) {
            String filter = "(&(objectclass=" + BundleProvider.class.getName() + ")" + "(" + "managedServerName" + "=" + "defaultJettyServer" + "))";
            ServiceTracker defaultServerTracker = new ServiceTracker(this._bundle.getBundleContext(), FrameworkUtil.createFilter((String)filter), null){

                public Object addingService(ServiceReference reference) {
                    try {
                        Object object = super.addingService(reference);
                        LOG.debug("Default Jetty Server registered {}", new Object[]{reference});
                        BundleWatcher.this._defaultServerReady = true;
                        BundleWatcher.this.openBundleTracker();
                        return object;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            };
            defaultServerTracker.open();
        } else {
            this.openBundleTracker();
        }
    }

    public Map<ServiceReference, BundleProvider> getDeployers(String managedServerName) {
        if (managedServerName == null) {
            managedServerName = "defaultJettyServer";
        }
        HashMap<ServiceReference, BundleProvider> candidates = new HashMap<ServiceReference, BundleProvider>();
        ServiceReference[] references = this._serviceTracker.getServiceReferences();
        if (references != null) {
            for (ServiceReference ref : references) {
                BundleProvider candidate;
                String name = (String)ref.getProperty("managedServerName");
                if (!managedServerName.equalsIgnoreCase(name) || (candidate = (BundleProvider)this._serviceTracker.getService(ref)) == null) continue;
                candidates.put(ref, candidate);
            }
        }
        return candidates;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (bundle.getState() == 32) {
            this.register(bundle);
        } else if (bundle.getState() == 16) {
            this.unregister(bundle);
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (bundle.getState() == 16 || bundle.getState() == 32) {
            this.unregister(bundle);
        }
        if (bundle.getState() == 32) {
            this.register(bundle);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.unregister(bundle);
    }

    protected void openBundleTracker() {
        this._bundleTracker.open();
    }

    private boolean register(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        boolean deployed = false;
        String serverName = (String)bundle.getHeaders().get("managedServerName");
        Map<ServiceReference, BundleProvider> candidates = this.getDeployers(serverName);
        if (candidates != null) {
            Iterator<Map.Entry<ServiceReference, BundleProvider>> itor = candidates.entrySet().iterator();
            while (!deployed && itor.hasNext()) {
                Map.Entry<ServiceReference, BundleProvider> e = itor.next();
                try {
                    deployed = e.getValue().bundleAdded(bundle);
                }
                catch (Exception x) {
                    LOG.warn("Error deploying bundle for jetty context", (Throwable)x);
                }
            }
        }
        return deployed;
    }

    private void unregister(Bundle bundle) {
        boolean undeployed = false;
        String serverName = (String)bundle.getHeaders().get("managedServerName");
        Map<ServiceReference, BundleProvider> candidates = this.getDeployers(serverName);
        if (candidates != null) {
            Iterator<Map.Entry<ServiceReference, BundleProvider>> itor = candidates.entrySet().iterator();
            while (!undeployed && itor.hasNext()) {
                Map.Entry<ServiceReference, BundleProvider> e = itor.next();
                try {
                    undeployed = e.getValue().bundleRemoved(bundle);
                }
                catch (Exception x) {
                    LOG.warn("Error undeploying Bundle representing jetty deployable ", (Throwable)x);
                }
            }
        }
    }
}

