/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils;

import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelperFactory;

public class Util {
    public static final String DEFAULT_DELIMS = ",;";

    public static String getManifestHeaderValue(String name, String altName, Dictionary manifest) {
        if (manifest == null) {
            return null;
        }
        if (name == null && altName == null) {
            return null;
        }
        if (name != null) {
            return (String)manifest.get(name);
        }
        return (String)manifest.get(altName);
    }

    public static List<URL> fileNamesAsURLs(String val, String delims) throws Exception {
        String separators = DEFAULT_DELIMS;
        if (delims == null) {
            delims = separators;
        }
        StringTokenizer tokenizer = new StringTokenizer(val, delims, false);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            urls.add(BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(new URL(tokenizer.nextToken())));
        }
        return urls;
    }

    public static void setProperty(Dictionary<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    public static String resolvePropertyValue(String value) {
        int ind = value.indexOf("${");
        if (ind == -1) {
            return value;
        }
        int ind2 = value.indexOf(125, ind);
        if (ind2 == -1) {
            return value;
        }
        String sysprop = value.substring(ind + 2, ind2);
        String defaultValue = null;
        int comma = sysprop.indexOf(44);
        if (comma != -1 && comma + 1 != sysprop.length()) {
            defaultValue = sysprop.substring(comma + 1);
            defaultValue = Util.resolvePropertyValue(defaultValue);
            sysprop = sysprop.substring(0, comma);
        } else {
            defaultValue = "${" + sysprop + "}";
        }
        String v = System.getProperty(sysprop);
        String reminder = value.length() > ind2 + 1 ? value.substring(ind2 + 1) : "";
        reminder = Util.resolvePropertyValue(reminder);
        if (v != null) {
            return value.substring(0, ind) + v + reminder;
        }
        return value.substring(0, ind) + defaultValue + reminder;
    }
}

