/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import org.eclipse.jetty.osgi.boot.internal.serverfactory.DefaultJettyAtJettyHomeHelper;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.JettyServerServiceTracker;
import org.eclipse.jetty.osgi.boot.internal.webapp.BundleWatcher;
import org.eclipse.jetty.osgi.boot.internal.webapp.ServiceWatcher;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class JettyBootstrapActivator
implements BundleActivator {
    private static final Logger LOG = Log.getLogger(JettyBootstrapActivator.class);
    private static JettyBootstrapActivator INSTANCE = null;
    private ServiceRegistration _registeredServer;
    private ServiceTracker _contextHandlerTracker;
    private PackageAdminServiceTracker _packageAdminServiceTracker;
    private BundleTracker _webBundleTracker;
    private JettyServerServiceTracker _jettyServerServiceTracker;

    public static JettyBootstrapActivator getInstance() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        try {
            INSTANCE = this;
            this._packageAdminServiceTracker = new PackageAdminServiceTracker(context);
            this._jettyServerServiceTracker = new JettyServerServiceTracker();
            context.addServiceListener((ServiceListener)this._jettyServerServiceTracker, "(objectclass=" + Server.class.getName() + ")");
            Server defaultServer = DefaultJettyAtJettyHomeHelper.startJettyAtJettyHome(context);
            this._contextHandlerTracker = new ServiceTracker(context, context.createFilter("(objectclass=" + ContextHandler.class.getName() + ")"), (ServiceTrackerCustomizer)new ServiceWatcher());
            this._contextHandlerTracker.open();
            BundleWatcher bundleTrackerCustomizer = new BundleWatcher();
            bundleTrackerCustomizer.setWaitForDefaultServer(defaultServer != null);
            this._webBundleTracker = new BundleTracker(context, 48, (BundleTrackerCustomizer)bundleTrackerCustomizer);
            bundleTrackerCustomizer.setBundleTracker(this._webBundleTracker);
            bundleTrackerCustomizer.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        block10: {
            try {
                if (this._webBundleTracker != null) {
                    this._webBundleTracker.close();
                    this._webBundleTracker = null;
                }
                if (this._contextHandlerTracker != null) {
                    this._contextHandlerTracker.close();
                    this._contextHandlerTracker = null;
                }
                if (this._jettyServerServiceTracker != null) {
                    this._jettyServerServiceTracker.stop();
                    context.removeServiceListener((ServiceListener)this._jettyServerServiceTracker);
                    this._jettyServerServiceTracker = null;
                }
                if (this._packageAdminServiceTracker != null) {
                    this._packageAdminServiceTracker.stop();
                    context.removeServiceListener((ServiceListener)this._packageAdminServiceTracker);
                    this._packageAdminServiceTracker = null;
                }
                if (this._registeredServer == null) break block10;
                try {
                    this._registeredServer.unregister();
                    this._registeredServer = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this._registeredServer = null;
                }
                catch (Throwable throwable) {
                    this._registeredServer = null;
                    throw throwable;
                }
            }
            finally {
                INSTANCE = null;
            }
        }
    }
}

