/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.AbstractWebAppProvider;
import org.eclipse.jetty.osgi.boot.ServiceProvider;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceWebAppProvider
extends AbstractWebAppProvider
implements ServiceProvider {
    private static final Logger LOG = Log.getLogger(AbstractWebAppProvider.class);
    private Map<ServiceReference, App> _serviceMap = new HashMap<ServiceReference, App>();
    private ServiceRegistration _serviceRegForServices;

    public ServiceWebAppProvider(ServerInstanceWrapper wrapper) {
        super(wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean serviceAdded(ServiceReference serviceRef, ContextHandler context) {
        String requiredTlds;
        String bundleInstallOverride;
        String extraClassPath;
        String webXml;
        if (context == null || !(context instanceof WebAppContext)) {
            return false;
        }
        String watermark = (String)serviceRef.getProperty("o.e.j.o.b.watermark");
        if (watermark != null && !"".equals(watermark)) {
            return false;
        }
        WebAppContext webApp = (WebAppContext)context;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        String contextPath = (String)serviceRef.getProperty("Web-ContextPath");
        if (contextPath == null) {
            contextPath = (String)serviceRef.getProperty("contextPath");
        }
        if (contextPath == null) {
            return false;
        }
        String base = (String)serviceRef.getProperty("Jetty-WarFolderPath");
        if (base == null) {
            base = (String)serviceRef.getProperty("war");
        }
        if (base == null) {
            return false;
        }
        String webdefaultXml = (String)serviceRef.getProperty("Jetty-defaultWebXmlFilePath");
        if (webdefaultXml == null) {
            webdefaultXml = (String)serviceRef.getProperty("defaultWebXmlFilePath");
        }
        if (webdefaultXml != null) {
            ((Dictionary)properties).put("Jetty-defaultWebXmlFilePath", webdefaultXml);
        }
        if ((webXml = (String)serviceRef.getProperty("Jetty-WebXmlFilePath")) == null) {
            webXml = (String)serviceRef.getProperty("webXmlFilePath");
        }
        if (webXml != null) {
            ((Dictionary)properties).put("Jetty-WebXmlFilePath", webXml);
        }
        if ((extraClassPath = (String)serviceRef.getProperty("Jetty-extraClasspath")) == null) {
            extraClassPath = (String)serviceRef.getProperty("extraClasspath");
        }
        if (extraClassPath != null) {
            ((Dictionary)properties).put("Jetty-extraClasspath", extraClassPath);
        }
        if ((bundleInstallOverride = (String)serviceRef.getProperty("Jetty-bundleInstall")) == null) {
            bundleInstallOverride = (String)serviceRef.getProperty("thisBundleInstall");
        }
        if (bundleInstallOverride != null) {
            ((Dictionary)properties).put("Jetty-bundleInstall", bundleInstallOverride);
        }
        if ((requiredTlds = (String)serviceRef.getProperty("Require-TldBundle")) == null) {
            requiredTlds = (String)serviceRef.getProperty("Require-TldBundle");
        }
        if (requiredTlds != null) {
            ((Dictionary)properties).put("Require-TldBundle", requiredTlds);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getServerInstanceWrapper().getParentClassLoaderForWebapps());
        try {
            String originId = ServiceWebAppProvider.getOriginId(serviceRef.getBundle(), base);
            ServiceApp app = new ServiceApp(this.getDeploymentManager(), (AppProvider)this, serviceRef.getBundle(), properties, originId);
            app.setContextPath(contextPath);
            app.setWebAppPath(base);
            app.setWebAppContext(webApp);
            this._serviceMap.put(serviceRef, app);
            this.getDeploymentManager().addApp((App)app);
            boolean bl = true;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public boolean serviceRemoved(ServiceReference serviceRef, ContextHandler context) {
        if (context == null || !(context instanceof WebAppContext)) {
            return false;
        }
        String watermark = (String)serviceRef.getProperty("o.e.j.o.b.watermark");
        if (watermark != null && !"".equals(watermark)) {
            return false;
        }
        App app = this._serviceMap.remove(serviceRef);
        if (app != null) {
            this.getDeploymentManager().removeApp(app);
            return true;
        }
        return false;
    }

    protected void doStart() throws Exception {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", this.getServerInstanceWrapper().getManagedServerName());
        this._serviceRegForServices = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(ServiceProvider.class.getName(), (Object)this, properties);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this._serviceRegForServices != null) {
            try {
                this._serviceRegForServices.unregister();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        super.doStop();
    }

    public class ServiceApp
    extends AbstractWebAppProvider.OSGiApp {
        public ServiceApp(DeploymentManager manager, AppProvider provider, Bundle bundle, Dictionary properties, String originId) {
            super(ServiceWebAppProvider.this, manager, provider, bundle, properties, originId);
        }

        public ServiceApp(DeploymentManager manager, AppProvider provider, Bundle bundle, String originId) {
            super(ServiceWebAppProvider.this, manager, provider, bundle, originId);
        }

        @Override
        public void registerAsOSGiService() throws Exception {
        }

        @Override
        protected void deregisterAsOSGiService() throws Exception {
        }
    }
}

