/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.boot.utils.Util;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DefaultJettyAtJettyHomeHelper {
    private static final Logger LOG = Log.getLogger(DefaultJettyAtJettyHomeHelper.class);
    public static final String JETTY_ETC_FILES = "jetty.etc.config.urls";
    public static final String DEFAULT_JETTY_ETC_FILES = "etc/jetty.xml,etc/jetty-selector.xml,etc/jetty-deployer.xml";
    public static final String DEFAULT_JETTYHOME = "/jettyhome";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server startJettyAtJettyHome(BundleContext bundleContext) throws Exception {
        String jettyHomeSysProp = System.getProperty("jetty.home");
        String jettyHomeBundleSysProp = System.getProperty("jetty.home.bundle");
        File jettyHomeDir = null;
        Bundle jettyHomeBundle = null;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (jettyHomeSysProp != null) {
            if ((jettyHomeSysProp = Util.resolvePropertyValue(jettyHomeSysProp)).startsWith("\"") && jettyHomeSysProp.endsWith("\"") || jettyHomeSysProp.startsWith("'") && jettyHomeSysProp.endsWith("'")) {
                jettyHomeSysProp = jettyHomeSysProp.substring(1, jettyHomeSysProp.length() - 1);
            }
            if (jettyHomeBundleSysProp != null) {
                LOG.warn("Both jetty.home and jetty.home.bundle property defined: jetty.home.bundle ignored.", new Object[0]);
            }
            if (!(jettyHomeDir = new File(jettyHomeSysProp)).exists() || !jettyHomeDir.isDirectory()) {
                LOG.warn("Unable to locate the jetty.home folder " + jettyHomeSysProp, new Object[0]);
                return null;
            }
            Util.setProperty(properties, "jetty.home", jettyHomeDir.getAbsolutePath());
        } else if (jettyHomeBundleSysProp != null) {
            jettyHomeBundleSysProp = Util.resolvePropertyValue(jettyHomeBundleSysProp);
            for (Bundle b : bundleContext.getBundles()) {
                if (b.getState() == 1 || !b.getSymbolicName().equals(jettyHomeBundleSysProp)) continue;
                jettyHomeBundle = b;
                break;
            }
            if (jettyHomeBundle == null) {
                LOG.warn("Unable to find the jetty.home.bundle named " + jettyHomeSysProp, new Object[0]);
                return null;
            }
        }
        if (jettyHomeDir == null && jettyHomeBundle == null) {
            LOG.warn("No default jetty created.", new Object[0]);
            return null;
        }
        List<URL> configURLs = jettyHomeDir != null ? DefaultJettyAtJettyHomeHelper.getJettyConfigurationURLs(jettyHomeDir) : DefaultJettyAtJettyHomeHelper.getJettyConfigurationURLs(jettyHomeBundle, properties);
        LOG.info("Configuring the default jetty server with {}", new Object[]{configURLs});
        LOG.info("JETTY.HOME=" + (String)((Dictionary)properties).get("jetty.home"), new Object[0]);
        ClassLoader contextCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JettyBootstrapActivator.class.getClassLoader());
            ((Dictionary)properties).put("managedServerName", "defaultJettyServer");
            Util.setProperty(properties, "jetty.host", System.getProperty("jetty.host"));
            Util.setProperty(properties, "jetty.port", System.getProperty("jetty.port"));
            Util.setProperty(properties, "jetty.port.ssl", System.getProperty("jetty.port.ssl"));
            Server server = ServerInstanceWrapper.configure(null, configURLs, properties);
            server.setAttribute("jetty.home", ((Dictionary)properties).get("jetty.home"));
            bundleContext.registerService(Server.class.getName(), (Object)server, properties);
            LOG.info("Default jetty server configured", new Object[0]);
            Server server2 = server;
            return server2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCl);
        }
    }

    private static List<URL> getJettyConfigurationURLs(File jettyhome) throws MalformedURLException {
        ArrayList<URL> configURLs = new ArrayList<URL>();
        String jettyetc = System.getProperty(JETTY_ETC_FILES, DEFAULT_JETTY_ETC_FILES);
        StringTokenizer tokenizer = new StringTokenizer(jettyetc, ";,", false);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken().trim();
            if (!next.startsWith("/") && next.indexOf(58) == -1) {
                configURLs.add(new File(jettyhome, next).toURI().toURL());
                continue;
            }
            configURLs.add(new URL(next));
        }
        return configURLs;
    }

    private static List<URL> getJettyConfigurationURLs(Bundle configurationBundle, Dictionary properties) throws Exception {
        ArrayList<URL> configURLs = new ArrayList<URL>();
        String files = System.getProperty(JETTY_ETC_FILES, DEFAULT_JETTY_ETC_FILES);
        StringTokenizer tokenizer = new StringTokenizer(files, ";,", false);
        while (tokenizer.hasMoreTokens()) {
            Resource res;
            String etcFile = tokenizer.nextToken().trim();
            if (etcFile.startsWith("/") || etcFile.indexOf(":") != -1) {
                configURLs.add(new URL(etcFile));
                continue;
            }
            Enumeration<URL> enUrls = BundleFileLocatorHelperFactory.getFactory().getHelper().findEntries(configurationBundle, etcFile);
            String home = null;
            if (enUrls == null || !enUrls.hasMoreElements()) {
                home = DEFAULT_JETTYHOME;
                String tmp = DEFAULT_JETTYHOME + (DEFAULT_JETTYHOME.endsWith("/") ? "" : "/") + etcFile;
                enUrls = BundleFileLocatorHelperFactory.getFactory().getHelper().findEntries(configurationBundle, tmp);
                LOG.info("Configuring jetty from bundle: {} with {}", new Object[]{configurationBundle.getSymbolicName(), tmp});
            }
            if (properties.get("jetty.home") == null && (res = DefaultJettyAtJettyHomeHelper.findDir(configurationBundle, home)) != null) {
                properties.put("jetty.home", res.toString());
            }
            if (enUrls == null || !enUrls.hasMoreElements()) {
                throw new IllegalStateException("Unable to locate a jetty configuration file for " + etcFile);
            }
            URL url = BundleFileLocatorHelperFactory.getFactory().getHelper().getFileURL(enUrls.nextElement());
            configURLs.add(url);
        }
        return configURLs;
    }

    public static Resource findDir(Bundle bundle, String dir) {
        if (bundle == null) {
            return null;
        }
        try {
            File f = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
            URL u = f.toURI().toURL();
            u = BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(u);
            Resource res = Resource.newResource((URL)u);
            String s = res.toString();
            if (s.endsWith(".jar") && s.startsWith("file:")) {
                res = JarResource.newJarResource((Resource)res);
            }
            if (dir != null) {
                res = res.addPath(dir);
            }
            return res;
        }
        catch (Exception e) {
            LOG.warn("Bad bundle location", (Throwable)e);
            return null;
        }
    }
}

