/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelperFactory;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class OSGiWebappClassLoader
extends WebAppClassLoader
implements BundleReference {
    private static final Logger __logger = Log.getLogger((String)OSGiWebappClassLoader.class.getName());
    public static final Set<String> JAR_WITH_SUCH_CLASS_MUST_BE_EXCLUDED = new HashSet<String>();
    private ClassLoader _osgiBundleClassLoader;
    private Bundle _contributor;
    private boolean _lookInOsgiFirst = true;
    private static Field _contextField;

    public static void addClassThatIdentifiesAJarThatMustBeRejected(Class<?> zclass) {
        JAR_WITH_SUCH_CLASS_MUST_BE_EXCLUDED.add(zclass.getName().replace('.', '/') + ".class");
    }

    public static void addClassThatIdentifiesAJarThatMustBeRejected(String zclassName) {
        JAR_WITH_SUCH_CLASS_MUST_BE_EXCLUDED.add(zclassName.replace('.', '/') + ".class");
    }

    public OSGiWebappClassLoader(ClassLoader parent, WebAppContext context, Bundle contributor) throws IOException {
        super(parent, (WebAppClassLoader.Context)context);
        this._contributor = contributor;
        this._osgiBundleClassLoader = BundleClassLoaderHelperFactory.getFactory().getHelper().getBundleClassLoader(contributor);
    }

    public Bundle getBundle() {
        return this._contributor;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> osgiUrls = this._osgiBundleClassLoader.getResources(name);
        Enumeration urls = super.getResources(name);
        if (this._lookInOsgiFirst) {
            return Collections.enumeration(this.toList(osgiUrls, urls));
        }
        return Collections.enumeration(this.toList(urls, osgiUrls));
    }

    public URL getResource(String name) {
        if (this._lookInOsgiFirst) {
            URL url = this._osgiBundleClassLoader.getResource(name);
            return url != null ? url : super.getResource(name);
        }
        URL url = super.getResource(name);
        return url != null ? url : this._osgiBundleClassLoader.getResource(name);
    }

    private List<URL> toList(Enumeration<URL> e, Enumeration<URL> e2) {
        ArrayList<URL> list = new ArrayList<URL>();
        while (e != null && e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        while (e2 != null && e2.hasMoreElements()) {
            list.add(e2.nextElement());
        }
        return list;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this._lookInOsgiFirst ? this._osgiBundleClassLoader.loadClass(name) : super.findClass(name);
        }
        catch (ClassNotFoundException cne) {
            try {
                return this._lookInOsgiFirst ? super.findClass(name) : this._osgiBundleClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException cne2) {
                throw cne;
            }
        }
    }

    public void addClassPath(String classPath) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            Resource resource = this.getContext().newResource(path);
            File file = resource.getFile();
            if (file != null && this.isAcceptableLibrary(file, JAR_WITH_SUCH_CLASS_MUST_BE_EXCLUDED)) {
                super.addClassPath(path);
                continue;
            }
            __logger.info("Did not add " + path + " to the classloader of the webapp " + this.getContext(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAcceptableLibrary(File file, Set<String> pathToClassFiles) {
        try {
            if (file.isDirectory()) {
                String criteria;
                Iterator<String> i$ = pathToClassFiles.iterator();
                do {
                    if (!i$.hasNext()) return true;
                } while (!new File(file, criteria = i$.next()).exists());
                return false;
            }
            JarFile jar = null;
            try {
                String criteria;
                jar = new JarFile(file);
                Iterator<String> i$ = pathToClassFiles.iterator();
                do {
                    if (!i$.hasNext()) return true;
                } while (jar.getEntry(criteria = i$.next()) == null);
                boolean bl = false;
                return bl;
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        catch (IOException e) {
            __logger.ignore((Throwable)e);
        }
        return true;
    }

    public void setWebappContext(WebAppContext webappContext) {
        try {
            if (_contextField == null) {
                _contextField = WebAppClassLoader.class.getDeclaredField("_context");
                _contextField.setAccessible(true);
            }
            _contextField.set((Object)this, webappContext);
            if (webappContext.getExtraClasspath() != null) {
                this.addClassPath(webappContext.getExtraClasspath());
            }
        }
        catch (Throwable t) {
            __logger.warn("Unable to set webappcontext", t);
        }
    }

    static {
        OSGiWebappClassLoader.addClassThatIdentifiesAJarThatMustBeRejected(HttpServlet.class);
    }
}

