/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.jetty.osgi.boot.internal.webapp.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DefaultJettyAtJettyHomeHelper {
    private static final Logger LOG = Log.getLogger(DefaultJettyAtJettyHomeHelper.class);
    public static final String JETTY_ETC_FILES = "jetty.etc.config.urls";
    public static final String DEFAULT_JETTY_ETC_FILES = "etc/jetty.xml,etc/jetty-selector.xml,etc/jetty-deployer.xml";
    public static final String DEFAULT_JETTYHOME = "/jettyhome/";

    public static Server startJettyAtJettyHome(BundleContext bundleContext) throws Exception {
        String jettyHomeSysProp = System.getProperty("jetty.home");
        String jettyHomeBundleSysProp = System.getProperty("jetty.home.bundle");
        File jettyHome = null;
        Bundle jettyHomeBundle = null;
        if (jettyHomeSysProp != null) {
            if ((jettyHomeSysProp = DefaultJettyAtJettyHomeHelper.resolvePropertyValue(jettyHomeSysProp)).startsWith("\"") && jettyHomeSysProp.endsWith("\"") || jettyHomeSysProp.startsWith("'") && jettyHomeSysProp.endsWith("'")) {
                jettyHomeSysProp = jettyHomeSysProp.substring(1, jettyHomeSysProp.length() - 1);
            }
            if (jettyHomeBundleSysProp != null) {
                LOG.warn("Both jetty.home and jetty.home.bundle property defined: jetty.home.bundle ignored.", new Object[0]);
            }
            if (!(jettyHome = new File(jettyHomeSysProp)).exists() || !jettyHome.isDirectory()) {
                LOG.warn("Unable to locate the jetty.home folder " + jettyHomeSysProp, new Object[0]);
                return null;
            }
        } else if (jettyHomeBundleSysProp != null) {
            jettyHomeBundleSysProp = DefaultJettyAtJettyHomeHelper.resolvePropertyValue(jettyHomeBundleSysProp);
            for (Bundle b : bundleContext.getBundles()) {
                if (!b.getSymbolicName().equals(jettyHomeBundleSysProp)) continue;
                jettyHomeBundle = b;
                break;
            }
            if (jettyHomeBundle == null) {
                LOG.warn("Unable to find the jetty.home.bundle named " + jettyHomeSysProp, new Object[0]);
                return null;
            }
        }
        if (jettyHome == null && jettyHomeBundle == null) {
            LOG.warn("No default jetty created.", new Object[0]);
            return null;
        }
        Server server = new Server();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", "defaultJettyServer");
        String configURLs = jettyHome != null ? DefaultJettyAtJettyHomeHelper.getJettyConfigurationURLs(jettyHome) : DefaultJettyAtJettyHomeHelper.getJettyConfigurationURLs(jettyHomeBundle);
        ((Dictionary)properties).put(JETTY_ETC_FILES, configURLs);
        LOG.info("Configuring the default jetty server with " + configURLs, new Object[0]);
        DefaultJettyAtJettyHomeHelper.setProperty(properties, "jetty.home", System.getProperty("jetty.home"));
        DefaultJettyAtJettyHomeHelper.setProperty(properties, "jetty.host", System.getProperty("jetty.host"));
        DefaultJettyAtJettyHomeHelper.setProperty(properties, "jetty.port", System.getProperty("jetty.port"));
        DefaultJettyAtJettyHomeHelper.setProperty(properties, "jetty.port.ssl", System.getProperty("jetty.port.ssl"));
        bundleContext.registerService(Server.class.getName(), (Object)server, properties);
        return server;
    }

    private static String getJettyConfigurationURLs(File jettyhome) {
        String jettyetc = System.getProperty(JETTY_ETC_FILES, DEFAULT_JETTY_ETC_FILES);
        StringTokenizer tokenizer = new StringTokenizer(jettyetc, ";,", false);
        StringBuilder res = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken().trim();
            if (!next.startsWith("/") && next.indexOf(58) == -1) {
                try {
                    next = new File(jettyhome, next).toURI().toURL().toString();
                }
                catch (MalformedURLException e) {
                    LOG.warn((Throwable)e);
                    continue;
                }
            }
            DefaultJettyAtJettyHomeHelper.appendToCommaSeparatedList(res, next);
        }
        return res.toString();
    }

    private static String getJettyConfigurationURLs(Bundle configurationBundle) {
        String files = System.getProperty(JETTY_ETC_FILES, DEFAULT_JETTY_ETC_FILES);
        StringTokenizer tokenizer = new StringTokenizer(files, ";,", false);
        StringBuilder res = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String etcFile = tokenizer.nextToken().trim();
            if (etcFile.startsWith("/") || etcFile.indexOf(":") != -1) {
                DefaultJettyAtJettyHomeHelper.appendToCommaSeparatedList(res, etcFile);
                continue;
            }
            Enumeration<URL> enUrls = BundleFileLocatorHelperFactory.getFactory().getHelper().findEntries(configurationBundle, etcFile);
            if (enUrls == null || !enUrls.hasMoreElements()) {
                String tmp = DEFAULT_JETTYHOME + etcFile;
                enUrls = BundleFileLocatorHelperFactory.getFactory().getHelper().findEntries(configurationBundle, tmp);
                LOG.info("Configuring jetty from bundle: " + configurationBundle.getSymbolicName() + " with " + tmp, new Object[0]);
            }
            if (enUrls == null || !enUrls.hasMoreElements()) {
                throw new IllegalStateException("Unable to locate a jetty configuration file for " + etcFile);
            }
            if (enUrls == null) continue;
            while (enUrls.hasMoreElements()) {
                URL url = BundleFileLocatorHelperFactory.getFactory().getHelper().getFileURL(enUrls.nextElement());
                DefaultJettyAtJettyHomeHelper.appendToCommaSeparatedList(res, url.toString());
            }
        }
        return res.toString();
    }

    private static void appendToCommaSeparatedList(StringBuilder buffer, String value) {
        if (buffer.length() != 0) {
            buffer.append(",");
        }
        buffer.append(value);
    }

    private static void setProperty(Dictionary<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    public static String resolvePropertyValue(String value) {
        int ind = value.indexOf("${");
        if (ind == -1) {
            return value;
        }
        int ind2 = value.indexOf(125, ind);
        if (ind2 == -1) {
            return value;
        }
        String sysprop = value.substring(ind + 2, ind2);
        String defaultValue = null;
        int comma = sysprop.indexOf(44);
        if (comma != -1 && comma + 1 != sysprop.length()) {
            defaultValue = sysprop.substring(comma + 1);
            defaultValue = DefaultJettyAtJettyHomeHelper.resolvePropertyValue(defaultValue);
            sysprop = sysprop.substring(0, comma);
        } else {
            defaultValue = "${" + sysprop + "}";
        }
        String v = System.getProperty(sysprop);
        String reminder = value.length() > ind2 + 1 ? value.substring(ind2 + 1) : "";
        reminder = DefaultJettyAtJettyHomeHelper.resolvePropertyValue(reminder);
        if (v != null) {
            return value.substring(0, ind) + v + reminder;
        }
        return value.substring(0, ind) + defaultValue + reminder;
    }
}

