/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.net.URL;
import java.util.Dictionary;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.util.log.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class WebBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (bundle.getState() == 32) {
            boolean isWebBundle = this.register(bundle);
            return isWebBundle ? bundle : null;
        }
        if (bundle.getState() == 16) {
            this.unregister(bundle);
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (bundle.getState() == 16 || bundle.getState() == 32) {
            this.unregister(bundle);
        }
        if (bundle.getState() == 32) {
            this.register(bundle);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.unregister(bundle);
    }

    private boolean register(Bundle bundle) {
        Dictionary dic = bundle.getHeaders();
        String warFolderRelativePath = (String)dic.get("Jetty-WarFolderPath");
        if (warFolderRelativePath != null) {
            String contextPath = (String)dic.get("Web-ContextPath");
            if (contextPath == null || !contextPath.startsWith("/")) {
                Log.warn((String)("The manifest header 'Jetty-WarFolderPath: " + warFolderRelativePath + "' in the bundle " + bundle.getSymbolicName() + " is not valid: there is no Web-ContextPath defined in the manifest."));
                return false;
            }
            try {
                JettyBootstrapActivator.registerWebapplication(bundle, warFolderRelativePath, contextPath);
                return true;
            }
            catch (Throwable e) {
                Log.warn((String)("Starting the web-bundle " + bundle.getSymbolicName() + " threw an exception."), (Throwable)e);
                return true;
            }
        }
        if (dic.get("Jetty-ContextFilePath") != null) {
            String[] pathes;
            String contextFileRelativePath = (String)dic.get("Jetty-ContextFilePath");
            if (contextFileRelativePath == null) {
                return false;
            }
            for (String path : pathes = contextFileRelativePath.split(",;")) {
                try {
                    JettyBootstrapActivator.registerContext(bundle, path.trim());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        URL rfc66Webxml = bundle.getEntry("/WEB-INF/web.xml");
        if (rfc66Webxml == null && dic.get("Web-ContextPath") == null) {
            return false;
        }
        String rfc66ContextPath = this.getWebContextPath(bundle, dic);
        try {
            JettyBootstrapActivator.registerWebapplication(bundle, ".", rfc66ContextPath);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }

    private String getWebContextPath(Bundle bundle, Dictionary<?, ?> dic) {
        String location;
        String[] toks;
        int lastDot;
        String rfc66ContextPath = (String)dic.get("Web-ContextPath");
        if (rfc66ContextPath == null && (lastDot = (rfc66ContextPath = (toks = (location = bundle.getLocation()).replace('\\', '/').split("/"))[toks.length - 1]).lastIndexOf(46)) != -1) {
            rfc66ContextPath = rfc66ContextPath.substring(0, lastDot);
        }
        if (!rfc66ContextPath.startsWith("/")) {
            rfc66ContextPath = "/" + rfc66ContextPath;
        }
        return rfc66ContextPath;
    }

    private void unregister(Bundle bundle) {
    }
}

