/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelperFactory;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiClassLoader
extends URLClassLoader {
    private static final Logger LOG = Log.getLogger(OSGiClassLoader.class);
    private Bundle _bundle;
    private ClassLoader _osgiBundleClassLoader;
    private boolean _lookInOsgiFirst = true;
    private ClassLoader _parent = this.getParent();

    public OSGiClassLoader(ClassLoader parent, Bundle bundle) {
        super(new URL[0], parent);
        this._bundle = bundle;
        this._osgiBundleClassLoader = BundleClassLoaderHelperFactory.getFactory().getHelper().getBundleClassLoader(this._bundle);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._parent != null && !this._lookInOsgiFirst) {
            tried_parent = true;
            if (this._parent != null) {
                url = this._parent.getResource(name);
            }
        }
        if (url == null && (url = this._osgiBundleClassLoader.getResource(name)) == null && name.startsWith("/")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HACK leading / off " + name, new Object[0]);
            }
            url = this._osgiBundleClassLoader.getResource(name.substring(1));
        }
        if (url == null && !tried_parent && this._parent != null) {
            url = this._parent.getResource(name);
        }
        if (url != null && LOG.isDebugEnabled()) {
            LOG.debug("getResource(" + name + ")=" + url, new Object[0]);
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c == null && this._parent != null && !this._lookInOsgiFirst) {
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("loaded " + c, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && this._parent != null && !tried_parent) {
            c = this._parent.loadClass(name);
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("loaded " + c + " from " + c.getClassLoader(), new Object[0]);
        }
        return c;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> osgiUrls = this._osgiBundleClassLoader.getResources(name);
        Enumeration<URL> urls = super.getResources(name);
        if (this._lookInOsgiFirst) {
            return Collections.enumeration(this.toList(osgiUrls, urls));
        }
        return Collections.enumeration(this.toList(urls, osgiUrls));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this._lookInOsgiFirst ? this._osgiBundleClassLoader.loadClass(name) : super.findClass(name);
        }
        catch (ClassNotFoundException cne) {
            try {
                return this._lookInOsgiFirst ? super.findClass(name) : this._osgiBundleClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException cne2) {
                throw cne;
            }
        }
    }

    private List<URL> toList(Enumeration<URL> e, Enumeration<URL> e2) {
        ArrayList<URL> list = new ArrayList<URL>();
        while (e != null && e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        while (e2 != null && e2.hasMoreElements()) {
            list.add(e2.nextElement());
        }
        return list;
    }
}

