/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.osgi.boot.AbstractWebAppProvider;
import org.eclipse.jetty.osgi.boot.BundleProvider;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class BundleWebAppProvider
extends AbstractWebAppProvider
implements BundleProvider {
    private static final Logger LOG = Log.getLogger(AbstractWebAppProvider.class);
    private Map<Bundle, App> _bundleMap = new HashMap<Bundle, App>();
    private ServiceRegistration _serviceRegForBundles;

    public BundleWebAppProvider(ServerInstanceWrapper wrapper) {
        super(wrapper);
    }

    protected void doStart() throws Exception {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", this.getServerInstanceWrapper().getManagedServerName());
        this._serviceRegForBundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(BundleProvider.class.getName(), (Object)this, properties);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this._serviceRegForBundles != null) {
            try {
                this._serviceRegForBundles.unregister();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        super.doStop();
    }

    public boolean bundleAdded(Bundle bundle) throws Exception {
        if (bundle == null) {
            return false;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getServerInstanceWrapper().getParentClassLoaderForWebapps());
        String contextPath = null;
        try {
            Dictionary headers = bundle.getHeaders();
            if (headers.get("Jetty-WarFolderPath") != null) {
                String base = (String)headers.get("Jetty-WarFolderPath");
                contextPath = BundleWebAppProvider.getContextPath(bundle);
                String originId = BundleWebAppProvider.getOriginId(bundle, base);
                AbstractWebAppProvider.OSGiApp app = new AbstractWebAppProvider.OSGiApp(this.getDeploymentManager(), this, bundle, originId);
                app.setWebAppPath(base);
                app.setContextPath(contextPath);
                this._bundleMap.put(bundle, app);
                this.getDeploymentManager().addApp((App)app);
                boolean bl = true;
                return bl;
            }
            if (bundle.getEntry("/WEB-INF/web.xml") != null) {
                String base = ".";
                contextPath = BundleWebAppProvider.getContextPath(bundle);
                String originId = BundleWebAppProvider.getOriginId(bundle, base);
                AbstractWebAppProvider.OSGiApp app = new AbstractWebAppProvider.OSGiApp(this.getDeploymentManager(), this, bundle, originId);
                app.setContextPath(contextPath);
                app.setWebAppPath(base);
                this._bundleMap.put(bundle, app);
                this.getDeploymentManager().addApp((App)app);
                boolean bl = true;
                return bl;
            }
            if (headers.get("Web-ContextPath") != null) {
                String base = ".";
                contextPath = (String)headers.get("Web-ContextPath");
                String originId = BundleWebAppProvider.getOriginId(bundle, base);
                AbstractWebAppProvider.OSGiApp app = new AbstractWebAppProvider.OSGiApp(this.getDeploymentManager(), this, bundle, originId);
                app.setContextPath(contextPath);
                app.setWebAppPath(base);
                this._bundleMap.put(bundle, app);
                this.getDeploymentManager().addApp((App)app);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public boolean bundleRemoved(Bundle bundle) throws Exception {
        App app = this._bundleMap.remove(bundle);
        if (app != null) {
            this.getDeploymentManager().removeApp(app);
            return true;
        }
        return false;
    }

    private static String getContextPath(Bundle bundle) {
        String location;
        String[] toks;
        int lastDot;
        Dictionary headers = bundle.getHeaders();
        String contextPath = (String)headers.get("Web-ContextPath");
        if (contextPath == null && (lastDot = (contextPath = (toks = (location = bundle.getLocation()).replace('\\', '/').split("/"))[toks.length - 1]).lastIndexOf(46)) != -1) {
            contextPath = contextPath.substring(0, lastDot);
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        return contextPath;
    }
}

