/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.providers.ScanningAppProvider;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;

public class OSGiAppProvider
extends ScanningAppProvider
implements AppProvider {
    private boolean _extractWars = true;
    private boolean _parentLoaderPriority = false;
    private String _defaultsDescriptor;
    private String _tldBundles;

    private static String getDeployedAppName(String contextFileName) {
        String lowername = contextFileName.toLowerCase();
        if (lowername.endsWith(".xml")) {
            String contextName = contextFileName.substring(0, lowername.length() - ".xml".length());
            return contextName;
        }
        return null;
    }

    public OSGiAppProvider() {
        super((FilenameFilter)new Filter());
        ((Filter)this._filenameFilter)._enclosedInstance = this;
    }

    public OSGiAppProvider(File contextsDir) throws IOException {
        this();
        this.setMonitoredDir(Resource.newResource((URI)contextsDir.toURI()));
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        if (app.getContextHandler() != null) {
            return app.getContextHandler();
        }
        throw new IllegalStateException("The App must be passed the instance of the ContextHandler when it is construsted");
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        super.setDeploymentManager(deploymentManager);
    }

    private static String getOriginId(Bundle contributor, String pathInBundle) {
        return contributor.getSymbolicName() + "-" + contributor.getVersion().toString() + (pathInBundle.startsWith("/") ? pathInBundle : "/" + pathInBundle);
    }

    public void addContext(Bundle contributor, String pathInBundle, ContextHandler context) throws Exception {
        this.addContext(OSGiAppProvider.getOriginId(contributor, pathInBundle), context);
    }

    public void addContext(String originId, ContextHandler context) throws Exception {
        if (context instanceof WebAppContext) {
            ((WebAppContext)context).setExtractWAR(this.isExtract());
        }
        App app = new App(this.getDeploymentManager(), (AppProvider)this, originId, context);
        this.getDeployedApps().put(context.getDisplayName(), app);
        this.getDeploymentManager().addApp(app);
    }

    protected App createApp(String filename) {
        String name = OSGiAppProvider.getDeployedAppName(filename);
        if (name != null) {
            return (App)this.getDeployedApps().get(name);
        }
        return null;
    }

    public void removeContext(ContextHandler context) throws Exception {
        App app = (App)this.getDeployedApps().remove(context.getDisplayName());
        if (app != null) {
            this.getDeploymentManager().removeApp(app);
        }
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._parentLoaderPriority = parentLoaderPriority;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public File getContextXmlDirAsFile() {
        try {
            Resource monitoredDir = this.getMonitoredDir();
            if (monitoredDir == null) {
                return null;
            }
            return monitoredDir.getFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getContextXmlDir() {
        try {
            Resource monitoredDir = this.getMonitoredDir();
            if (monitoredDir == null) {
                return null;
            }
            return monitoredDir.getFile().toURI().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isExtract() {
        return this._extractWars;
    }

    public void setExtract(boolean extract) {
        this._extractWars = extract;
    }

    public void setContextXmlDir(String contextsDir) {
        this.setMonitoredDir(contextsDir);
    }

    public void setTldBundles(String tldBundles) {
        this._tldBundles = tldBundles;
    }

    public String getTldBundles() {
        return this._tldBundles;
    }

    private static class Filter
    implements FilenameFilter {
        OSGiAppProvider _enclosedInstance;

        private Filter() {
        }

        public boolean accept(File dir, String name) {
            String contextName;
            if (!new File(dir, name).isDirectory() && (contextName = OSGiAppProvider.getDeployedAppName(name)) != null) {
                App app = (App)this._enclosedInstance.getDeployedApps().get(contextName);
                return app != null;
            }
            return false;
        }
    }
}

