/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jetty.osgi.boot.internal.webapp.WebappRegistrationHelper;
import org.eclipse.jetty.util.URIUtil;

class JettyHomeHelper {
    static boolean magic_install_only_in_pde = Boolean.valueOf(System.getProperty("jetty.magic.home.pde.only", "true"));

    JettyHomeHelper() {
    }

    static String setupJettyHomeInEclipsePDE(File thisbundlejar) {
        File ecFolder = JettyHomeHelper.getParentFolderOfMagicHome();
        if (ecFolder == null || !ecFolder.exists()) {
            return null;
        }
        File jettyhome = new File(ecFolder, "jettyhome");
        try {
            String path = jettyhome.getCanonicalPath();
            if (jettyhome.exists()) {
                System.setProperty("jetty.home", path);
                return path;
            }
            JettyHomeHelper.unzipJettyHomeIntoDirectory(thisbundlejar, ecFolder);
            System.setProperty("jetty.home", path);
            return path;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isPDEDevelopment() {
        String eclipseCommands = System.getProperty("eclipse.commands");
        return eclipseCommands != null && eclipseCommands.indexOf("-dev") != -1 && (eclipseCommands.indexOf("-dev\n") != -1 || eclipseCommands.indexOf("-dev\r") != -1 || eclipseCommands.indexOf("-dev ") != -1);
    }

    private static File getConfigurationAreaDirectory() {
        return JettyHomeHelper.getFile(System.getProperty("osgi.configuration.area"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipJettyHomeIntoDirectory(File thisbundlejar, File parentOfMagicJettyHome) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(thisbundlejar);
            Enumeration<? extends ZipEntry> files = zipFile.entries();
            File f = null;
            FileOutputStream fos = null;
            while (files.hasMoreElements()) {
                try {
                    ZipEntry entry = files.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith("jettyhome")) continue;
                    InputStream eis = zipFile.getInputStream(entry);
                    byte[] buffer = new byte[1024];
                    int bytesRead = 0;
                    f = new File(parentOfMagicJettyHome, entry.getName());
                    if (entry.isDirectory()) {
                        f.mkdirs();
                        continue;
                    }
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                    fos = new FileOutputStream(f);
                    while ((bytesRead = eis.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                    fos = null;
                }
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static File getParentFolderOfMagicHome() {
        File specifiedMagicParent;
        String magicParent = WebappRegistrationHelper.stripQuotesIfPresent(System.getProperty("jetty.magic.home.parent"));
        String magicParentValue = magicParent != null ? System.getProperty(magicParent) : null;
        File file = specifiedMagicParent = magicParentValue != null ? JettyHomeHelper.getFile(magicParentValue) : JettyHomeHelper.getFile(magicParent);
        if (specifiedMagicParent != null && specifiedMagicParent.exists()) {
            return specifiedMagicParent;
        }
        if (JettyHomeHelper.isPDEDevelopment()) {
            return JettyHomeHelper.getConfigurationAreaDirectory();
        }
        return null;
    }

    private static File getFile(String file) {
        if (file == null) {
            return null;
        }
        file = WebappRegistrationHelper.stripQuotesIfPresent(file);
        try {
            if (file.startsWith("file:/")) {
                if (!file.startsWith("file://")) {
                    return new File(new URI(URIUtil.encodePath((String)file)));
                }
                return new File(new URL(file).toURI());
            }
            return new File(file);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new File(file);
        }
    }
}

