/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.OSGiAppProvider;
import org.eclipse.jetty.osgi.boot.internal.jsp.TldLocatableURLClassloader;
import org.eclipse.jetty.osgi.boot.internal.webapp.JettyHomeHelper;
import org.eclipse.jetty.osgi.boot.internal.webapp.LibExtClassLoaderHelper;
import org.eclipse.jetty.osgi.boot.internal.webapp.OSGiWebappClassLoader;
import org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelper;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.WebappRegistrationCustomizer;
import org.eclipse.jetty.osgi.boot.utils.internal.DefaultBundleClassLoaderHelper;
import org.eclipse.jetty.osgi.boot.utils.internal.DefaultFileLocatorHelper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappRegistrationHelper {
    private static Logger __logger = Log.getLogger((String)WebappRegistrationHelper.class.getName());
    private static boolean INITIALIZED = false;
    public static BundleClassLoaderHelper BUNDLE_CLASS_LOADER_HELPER = null;
    public static BundleFileLocatorHelper BUNDLE_FILE_LOCATOR_HELPER = null;
    public static Collection<WebappRegistrationCustomizer> JSP_REGISTRATION_HELPERS = new ArrayList<WebappRegistrationCustomizer>();
    private Server _server;
    private ContextHandlerCollection _ctxtHandler;
    private URLClassLoader _commonParentClassLoaderForWebapps;
    private DeploymentManager _deploymentManager;
    private OSGiAppProvider _provider;

    public WebappRegistrationHelper(Server server) {
        this._server = server;
        WebappRegistrationHelper.staticInit();
    }

    private static synchronized void staticInit() {
        if (!INITIALIZED) {
            INITIALIZED = true;
            try {
                BUNDLE_CLASS_LOADER_HELPER = (BundleClassLoaderHelper)Class.forName("org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelperImpl").newInstance();
            }
            catch (Throwable t) {
                BUNDLE_CLASS_LOADER_HELPER = new DefaultBundleClassLoaderHelper();
            }
            try {
                BUNDLE_FILE_LOCATOR_HELPER = (BundleFileLocatorHelper)Class.forName("org.eclipse.jetty.osgi.boot.utils.FileLocatorHelperImpl").newInstance();
            }
            catch (Throwable t) {
                BUNDLE_FILE_LOCATOR_HELPER = new DefaultFileLocatorHelper();
            }
        }
    }

    public static String stripQuotesIfPresent(String filePath) {
        if (filePath == null) {
            return null;
        }
        if ((filePath.startsWith("\"") || filePath.startsWith("'")) && (filePath.endsWith("\"") || filePath.endsWith("'"))) {
            return filePath.substring(1, filePath.length() - 1);
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(BundleContext context, Map<String, String> configProperties) throws Exception {
        File _installLocation = BUNDLE_FILE_LOCATOR_HELPER.getBundleInstallLocation(context.getBundle());
        boolean bootBundleCanBeJarred = true;
        String jettyHome = WebappRegistrationHelper.stripQuotesIfPresent(System.getProperty("jetty.home"));
        if (jettyHome == null || jettyHome.length() == 0) {
            if (_installLocation.getName().endsWith(".jar")) {
                jettyHome = JettyHomeHelper.setupJettyHomeInEclipsePDE(_installLocation);
            }
            if (jettyHome == null) {
                jettyHome = _installLocation.getAbsolutePath() + "/jettyhome";
                bootBundleCanBeJarred = false;
            }
        }
        System.setProperty("jetty.home", jettyHome);
        String jettyLogs = WebappRegistrationHelper.stripQuotesIfPresent(System.getProperty("jetty.logs"));
        if (jettyLogs == null || jettyLogs.length() == 0) {
            System.setProperty("jetty.logs", jettyHome + "/logs");
        }
        if (!bootBundleCanBeJarred && !_installLocation.isDirectory()) {
            String install = _installLocation != null ? _installLocation.getCanonicalPath() : " unresolved_install_location";
            throw new IllegalArgumentException("The system property -Djetty.home must be set to a directory or the bundle " + context.getBundle().getSymbolicName() + " installed here " + install + " must be unjarred.");
        }
        try {
            System.err.println("JETTY_HOME set to " + new File(jettyHome).getCanonicalPath());
        }
        catch (Throwable t) {
            System.err.println("JETTY_HOME _set to " + new File(jettyHome).getAbsolutePath());
        }
        ClassLoader contextCl = Thread.currentThread().getContextClassLoader();
        try {
            File jettyHomeF = new File(jettyHome);
            try {
                URLClassLoader libExtClassLoader = LibExtClassLoaderHelper.createLibEtcClassLoaderHelper(jettyHomeF, this._server, JettyBootstrapActivator.class.getClassLoader());
                URL[] jarsWithTlds = this.getJarsWithTlds();
                this._commonParentClassLoaderForWebapps = jarsWithTlds == null ? libExtClassLoader : new TldLocatableURLClassloader(libExtClassLoader, this.getJarsWithTlds());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            Thread.currentThread().setContextClassLoader(this._commonParentClassLoaderForWebapps);
            String jettyetc = System.getProperty("jetty.etc.files", "etc/jetty.xml");
            StringTokenizer tokenizer = new StringTokenizer(jettyetc, ";,");
            Map<String, Object> id_map = new HashMap<String, Server>();
            id_map.put("Server", this._server);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("jetty.home", jettyHome);
            properties.put("jetty.host", System.getProperty("jetty.host", ""));
            properties.put("jetty.port", System.getProperty("jetty.port", "8080"));
            properties.put("jetty.port.ssl", System.getProperty("jetty.port.ssl", "8443"));
            while (tokenizer.hasMoreTokens()) {
                File conffile;
                String etcFile = tokenizer.nextToken().trim();
                File file = conffile = etcFile.startsWith("/") ? new File(etcFile) : new File(jettyHomeF, etcFile);
                if (!conffile.exists()) {
                    __logger.warn("Unable to resolve the jetty/etc file " + etcFile);
                    if (!"etc/jetty.xml".equals(etcFile)) continue;
                    __logger.info("Configuring default server on 8080");
                    SelectChannelConnector connector = new SelectChannelConnector();
                    connector.setPort(8080);
                    this._server.addConnector((Connector)connector);
                    HandlerCollection handlers = new HandlerCollection();
                    ContextHandlerCollection contexts = new ContextHandlerCollection();
                    RequestLogHandler requestLogHandler = new RequestLogHandler();
                    handlers.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
                    this._server.setHandler((Handler)handlers);
                    continue;
                }
                try {
                    XmlConfiguration config = new XmlConfiguration((InputStream)new FileInputStream(conffile));
                    config.setIdMap(id_map);
                    config.setProperties(properties);
                    config.configure();
                    id_map = config.getIdMap();
                }
                catch (SAXParseException saxparse) {
                    Log.getLogger((String)WebappRegistrationHelper.class.getName()).warn("Unable to configure the jetty/etc file " + etcFile, (Throwable)saxparse);
                    throw saxparse;
                }
            }
            this.init();
            this._server.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCl);
        }
    }

    private void init() {
        this._ctxtHandler = (ContextHandlerCollection)this._server.getChildHandlerByClass(ContextHandlerCollection.class);
        List deployers = this._server.getBeans(DeploymentManager.class);
        if (deployers != null && !deployers.isEmpty()) {
            this._deploymentManager = (DeploymentManager)deployers.get(0);
            for (AppProvider provider : this._deploymentManager.getAppProviders()) {
                if (!(provider instanceof OSGiAppProvider)) continue;
                this._provider = (OSGiAppProvider)provider;
                break;
            }
            if (this._provider == null) {
                try {
                    this._provider = new OSGiAppProvider();
                    this._provider.setMonitoredDir(Resource.newResource((URI)this.getDefaultOSGiContextsHome(new File(System.getProperty("jetty.home"))).toURI()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this._deploymentManager.addAppProvider((AppProvider)this._provider);
            }
        }
        if (this._ctxtHandler == null || this._provider == null) {
            throw new IllegalStateException("ERROR: No ContextHandlerCollection or OSGiAppProvider configured");
        }
    }

    public ContextHandler registerWebapplication(Bundle bundle, String webappFolderPath, String contextPath, String extraClasspath, String overrideBundleInstallLocation, String webXmlPath, String defaultWebXmlPath) throws Exception {
        File bundleInstall = overrideBundleInstallLocation == null ? BUNDLE_FILE_LOCATOR_HELPER.getBundleInstallLocation(bundle) : new File(overrideBundleInstallLocation);
        File webapp = null;
        webapp = webappFolderPath != null && webappFolderPath.length() != 0 && !webappFolderPath.equals(".") ? (webappFolderPath.startsWith("/") || webappFolderPath.startsWith("file:/") ? new File(webappFolderPath) : new File(bundleInstall, webappFolderPath)) : bundleInstall;
        if (!webapp.exists()) {
            throw new IllegalArgumentException("Unable to locate " + webappFolderPath + " inside " + (bundleInstall != null ? bundleInstall.getAbsolutePath() : "unlocated bundle '" + bundle.getSymbolicName() + "'"));
        }
        return this.registerWebapplication(bundle, webapp, contextPath, extraClasspath, bundleInstall, webXmlPath, defaultWebXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextHandler registerWebapplication(Bundle contributor, File webapp, String contextPath, String extraClasspath, File bundleInstall, String webXmlPath, String defaultWebXmlPath) throws Exception {
        WebAppContext webAppContext;
        ClassLoader contextCl;
        block8: {
            contextCl = Thread.currentThread().getContextClassLoader();
            String[] oldServerClasses = null;
            WebAppContext context = null;
            try {
                OSGiWebappClassLoader composite = this.createWebappClassLoader(contributor);
                Thread.currentThread().setContextClassLoader((ClassLoader)((Object)composite));
                context = new WebAppContext(webapp.getAbsolutePath(), contextPath);
                context.setExtraClasspath(extraClasspath);
                if (webXmlPath != null && webXmlPath.length() != 0) {
                    File webXml = null;
                    webXml = webXmlPath.startsWith("/") || webXmlPath.startsWith("file:/") ? new File(webXmlPath) : new File(bundleInstall, webXmlPath);
                    if (webXml.exists()) {
                        context.setDescriptor(webXml.getAbsolutePath());
                    }
                }
                if (defaultWebXmlPath == null || defaultWebXmlPath.length() == 0) {
                    defaultWebXmlPath = this._provider.getDefaultsDescriptor();
                }
                if (defaultWebXmlPath != null && defaultWebXmlPath.length() != 0) {
                    File defaultWebXml = null;
                    defaultWebXml = defaultWebXmlPath.startsWith("/") || defaultWebXmlPath.startsWith("file:/") ? new File(webXmlPath) : new File(bundleInstall, defaultWebXmlPath);
                    if (defaultWebXml.exists()) {
                        context.setDefaultsDescriptor(defaultWebXml.getAbsolutePath());
                    }
                }
                context.setParentLoaderPriority(this._provider.isParentLoaderPriority());
                this.configureWebAppContext(context, contributor);
                this.configureWebappClassLoader(contributor, (ContextHandler)context, composite);
                oldServerClasses = context.getServerClasses();
                context.setServerClasses(null);
                this._provider.addContext((ContextHandler)context);
                webAppContext = context;
                if (context == null || oldServerClasses == null) break block8;
            }
            catch (Throwable throwable) {
                if (context != null && oldServerClasses != null) {
                    context.setServerClasses(oldServerClasses);
                }
                Thread.currentThread().setContextClassLoader(contextCl);
                throw throwable;
            }
            context.setServerClasses(oldServerClasses);
        }
        Thread.currentThread().setContextClassLoader(contextCl);
        return webAppContext;
    }

    public void unregister(ContextHandler contextHandler) throws Exception {
        contextHandler.stop();
        this._ctxtHandler.removeHandler((Handler)contextHandler);
    }

    File getDefaultOSGiContextsHome(File jettyHome) {
        String jettyContextsHome = System.getProperty("jetty.osgi.contexts.home");
        if (jettyContextsHome != null) {
            File contextsHome = new File(jettyContextsHome);
            if (!contextsHome.exists() || !contextsHome.isDirectory()) {
                throw new IllegalArgumentException("the ${jetty.osgi.contexts.home} '" + jettyContextsHome + " must exist and be a folder");
            }
            return contextsHome;
        }
        return new File(jettyHome, "/contexts");
    }

    File getOSGiContextsHome() {
        return this._provider.getContextXmlDirAsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextHandler registerContext(Bundle contributor, String contextFileRelativePath, String extraClasspath, String overrideBundleInstallLocation) throws Exception {
        File contextFile;
        File prodContextFile;
        File contextsHome = this._provider.getContextXmlDirAsFile();
        if (contextsHome != null && (prodContextFile = new File(contextsHome, contributor.getSymbolicName() + "/" + contextFileRelativePath)).exists()) {
            return this.registerContext(contributor, prodContextFile, extraClasspath, overrideBundleInstallLocation);
        }
        File file = contextFile = overrideBundleInstallLocation != null ? new File(overrideBundleInstallLocation, contextFileRelativePath) : new File(BUNDLE_FILE_LOCATOR_HELPER.getBundleInstallLocation(contributor), contextFileRelativePath);
        if (contextFile.exists()) {
            return this.registerContext(contributor, contextFile, extraClasspath, overrideBundleInstallLocation);
        }
        if (contextFileRelativePath.startsWith("./")) {
            contextFileRelativePath = contextFileRelativePath.substring(1);
        }
        if (!contextFileRelativePath.startsWith("/")) {
            contextFileRelativePath = "/" + contextFileRelativePath;
        }
        if (overrideBundleInstallLocation == null) {
            URL contextURL = contributor.getEntry(contextFileRelativePath);
            if (contextURL != null) {
                return this.registerContext(contributor, contextURL.openStream(), extraClasspath, overrideBundleInstallLocation);
            }
        } else {
            JarFile zipFile = null;
            try {
                zipFile = new JarFile(overrideBundleInstallLocation);
                ZipEntry entry = zipFile.getEntry(contextFileRelativePath.substring(1));
                ContextHandler contextHandler = this.registerContext(contributor, zipFile.getInputStream(entry), extraClasspath, overrideBundleInstallLocation);
                return contextHandler;
            }
            catch (Throwable t) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        throw new IllegalArgumentException("Could not find the context file " + contextFileRelativePath + " for the bundle " + contributor.getSymbolicName() + (overrideBundleInstallLocation != null ? " using the install location " + overrideBundleInstallLocation : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextHandler registerContext(Bundle contributor, File contextFile, String extraClasspath, String overrideBundleInstallLocation) throws Exception {
        InputStream contextFileInputStream = null;
        try {
            contextFileInputStream = new BufferedInputStream(new FileInputStream(contextFile));
            ContextHandler contextHandler = this.registerContext(contributor, contextFileInputStream, extraClasspath, overrideBundleInstallLocation);
            return contextHandler;
        }
        finally {
            if (contextFileInputStream != null) {
                try {
                    contextFileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextHandler registerContext(Bundle contributor, InputStream contextFileInputStream, String extraClasspath, String overrideBundleInstallLocation) throws Exception {
        ContextHandler contextHandler;
        ClassLoader contextCl;
        block7: {
            ContextHandler context;
            OSGiWebappClassLoader composite;
            WebAppContext webAppContext;
            String[] oldServerClasses;
            block5: {
                ContextHandler contextHandler2;
                block6: {
                    contextCl = Thread.currentThread().getContextClassLoader();
                    oldServerClasses = null;
                    webAppContext = null;
                    try {
                        composite = this.createWebappClassLoader(contributor);
                        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)composite));
                        context = this.createContextHandler(contributor, contextFileInputStream, extraClasspath, overrideBundleInstallLocation);
                        if (context != null) break block5;
                        contextHandler2 = null;
                        if (webAppContext == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (webAppContext != null) {
                            webAppContext.setServerClasses(oldServerClasses);
                        }
                        Thread.currentThread().setContextClassLoader(contextCl);
                        throw throwable;
                    }
                    webAppContext.setServerClasses(oldServerClasses);
                }
                Thread.currentThread().setContextClassLoader(contextCl);
                return contextHandler2;
            }
            this.configureWebappClassLoader(contributor, context, composite);
            if (context instanceof WebAppContext) {
                webAppContext = (WebAppContext)context;
                oldServerClasses = webAppContext.getServerClasses();
                webAppContext.setServerClasses(null);
            }
            context.start();
            contextHandler = context;
            if (webAppContext == null) break block7;
            webAppContext.setServerClasses(oldServerClasses);
        }
        Thread.currentThread().setContextClassLoader(contextCl);
        return contextHandler;
    }

    private URL[] getJarsWithTlds() throws Exception {
        ArrayList<URL> res = new ArrayList<URL>();
        for (WebappRegistrationCustomizer regCustomizer : JSP_REGISTRATION_HELPERS) {
            URL[] urls;
            for (URL url : urls = regCustomizer.getJarsWithTlds(BUNDLE_FILE_LOCATOR_HELPER)) {
                if (res.contains(url)) continue;
                res.add(url);
            }
        }
        if (!res.isEmpty()) {
            return res.toArray(new URL[res.size()]);
        }
        return null;
    }

    protected void configureWebAppContext(WebAppContext wah, Bundle contributor) {
        wah.setAttribute("osgi-bundlecontext", (Object)contributor.getBundleContext());
    }

    protected ContextHandler createContextHandler(Bundle bundle, File contextFile, String extraClasspath, String overrideBundleInstallLocation) {
        try {
            return this.createContextHandler(bundle, new BufferedInputStream(new FileInputStream(contextFile)), extraClasspath, overrideBundleInstallLocation);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    protected ContextHandler createContextHandler(Bundle bundle, InputStream contextInputStream, String extraClasspath, String overrideBundleInstallLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void configureWebappClassLoader(Bundle contributor, ContextHandler context, OSGiWebappClassLoader webappClassLoader) throws Exception {
        if (context instanceof WebAppContext) {
            WebAppContext webappCtxt = (WebAppContext)context;
            context.setClassLoader((ClassLoader)((Object)webappClassLoader));
            webappClassLoader.setWebappContext(webappCtxt);
        } else {
            context.setClassLoader((ClassLoader)((Object)webappClassLoader));
        }
    }

    protected OSGiWebappClassLoader createWebappClassLoader(Bundle contributor) throws Exception {
        OSGiWebappClassLoader webappClassLoader = new OSGiWebappClassLoader(this._commonParentClassLoaderForWebapps, new WebAppContext(), contributor);
        return webappClassLoader;
    }

    private void setThisBundleHomeProperty(Bundle bundle, HashMap<String, Object> properties, String overrideBundleInstallLocation) {
        try {
            File location = overrideBundleInstallLocation != null ? new File(overrideBundleInstallLocation) : BUNDLE_FILE_LOCATOR_HELPER.getBundleInstallLocation(bundle);
            properties.put("this.bundle.install", location.getCanonicalPath());
        }
        catch (Throwable t) {
            System.err.println("Unable to set 'this.bundle.install'  for the bundle " + bundle.getSymbolicName());
            t.printStackTrace();
        }
    }
}

