/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.warurl.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarBundleManifestGenerator {
    private static final String MISSING_VERSION = "0.0.1.unknown";
    private static final String MISSING_MANIFEST_VERSION = "2";

    public static Manifest createBundleManifest(Manifest originalManifest, URL url, JarFile jarFile) {
        Manifest res = new Manifest();
        res.getMainAttributes().putAll((Map<?, ?>)WarBundleManifestGenerator.createBundleManifest(originalManifest.getMainAttributes(), url.toString(), jarFile));
        return res;
    }

    private static Attributes createBundleManifest(Attributes originalManifest, String url, JarFile jarFile) {
        String webContextPath;
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entries : originalManifest.entrySet()) {
            res.put(entries.getKey().toString(), String.valueOf(entries.getValue()));
        }
        MultiMap<String> params = WarBundleManifestGenerator.parseQueryString(url);
        String version = params.getString((Object)"Bundle-Version");
        if (version != null) {
            res.put("Bundle-Version", version);
        } else {
            String versionInManifest = (String)res.get("Bundle-Version");
            if (versionInManifest == null) {
                res.put("Bundle-Version", MISSING_VERSION);
            }
        }
        String manversion = params.getString((Object)"Bundle-ManifestVersion");
        if (manversion != null) {
            res.put("Bundle-ManifestVersion", manversion);
        } else {
            int manv = 2;
            try {
                String versionInManifest = (String)res.get("Bundle-ManifestVersion");
                if (versionInManifest != null) {
                    manv = Integer.parseInt(versionInManifest.trim());
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            res.put("Bundle-ManifestVersion", String.valueOf(manv < 2 ? 2 : manv));
        }
        String symbname = params.getString((Object)"Bundle-SymbolicName");
        if (symbname != null) {
            res.put("Bundle-SymbolicName", symbname);
        } else {
            symbname = (String)res.get("Bundle-SymbolicName");
            if (symbname == null) {
                int lastSlash = url.lastIndexOf(47);
                int beforeQueryString = url.indexOf(lastSlash, 63);
                if (beforeQueryString == -1 && (beforeQueryString = url.indexOf(lastSlash, 35)) == -1) {
                    beforeQueryString = url.length();
                }
                symbname = url.substring(lastSlash + 1, beforeQueryString);
                res.put("Bundle-SymbolicName", symbname);
            }
        }
        String extraBundleClasspath = params.getString((Object)"Bundle-ClassPath");
        String alreadyBundleClasspath = (String)res.get("Bundle-ClassPath");
        if (alreadyBundleClasspath == null) {
            StringBuilder bundleClasspath = new StringBuilder();
            if (jarFile == null || jarFile.getJarEntry("WEB-INF/classes/") != null) {
                bundleClasspath.append("WEB-INF/classes");
            }
            if (jarFile != null) {
                List<String> libs = WarBundleManifestGenerator.getJarsInWebInfLib(jarFile);
                if (extraBundleClasspath != null) {
                    libs.add(extraBundleClasspath);
                }
                for (String lib : libs) {
                    if (bundleClasspath.length() != 0) {
                        bundleClasspath.append(",");
                    }
                    bundleClasspath.append(lib);
                }
            }
            alreadyBundleClasspath = bundleClasspath.toString();
        }
        res.put("Bundle-ClassPath", alreadyBundleClasspath + (extraBundleClasspath == null ? "" : "," + extraBundleClasspath));
        String extraImportPackage = params.getString((Object)"Import-Package");
        String alreadyImportPackage = (String)res.get("Import-Package");
        if (alreadyImportPackage == null) {
            alreadyImportPackage = "javax.servlet; version=\"2.5\",javax.servlet.http;version=\"2.5\",javax.el;version=\"1.0\"javax.jsp;version=\"2.1\";resolution:=optional,javax.jsp.tagext;version=\"2.1\";resolution:=optional";
        }
        if (extraImportPackage != null) {
            res.put("Import-Package", (alreadyImportPackage == null ? "" : alreadyImportPackage + ",") + extraImportPackage);
        }
        String extraExportPackage = params.getString((Object)"Export-Package");
        String alreadyExportPackage = (String)res.get("Export-Package");
        if (extraExportPackage != null) {
            res.put("Export-Package", (alreadyExportPackage == null ? "" : alreadyExportPackage + ",") + extraImportPackage);
        }
        if ((webContextPath = params.getString((Object)"Web-ContextPath")) != null) {
            res.put("Web-ContextPath", webContextPath);
        } else {
            webContextPath = (String)res.get("Web-ContextPath");
            if (webContextPath == null) {
                webContextPath = symbname.endsWith(".war") ? "/" + symbname.substring(0, symbname.length() - ".war".length()) : "/" + symbname;
                res.put("Web-ContextPath", webContextPath);
            }
        }
        String jspExtractLocation = params.getString((Object)"Web-JSPExtractLocation");
        if (jspExtractLocation != null) {
            res.put("Web-JSPExtractLocation", jspExtractLocation);
        }
        Attributes newAttrs = new Attributes();
        for (Map.Entry e : res.entrySet()) {
            newAttrs.putValue((String)e.getKey(), (String)e.getValue());
        }
        return newAttrs;
    }

    private static MultiMap<String> parseQueryString(String url) {
        MultiMap res = new MultiMap();
        int questionMarkIndex = url.indexOf(63);
        if (questionMarkIndex == -1) {
            return res;
        }
        int poundIndex = url.indexOf(35);
        if (poundIndex == -1) {
            poundIndex = url.length();
        }
        UrlEncoded.decodeUtf8To((byte[])url.getBytes(), (int)(questionMarkIndex + 1), (int)(poundIndex - questionMarkIndex - 1), (MultiMap)res);
        return res;
    }

    private static List<String> getJarsInWebInfLib(JarFile jarFile) {
        ArrayList<String> res = new ArrayList<String>();
        Enumeration<JarEntry> en = jarFile.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            if (!e.getName().startsWith("WEB-INF/lib/") || !e.getName().endsWith(".jar")) continue;
            res.add(e.getName());
        }
        return res;
    }
}

