/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.BuffersFactory;

public class WebSocketBuffers {
    private final int _bufferSize;
    private final Buffers _buffers;
    private final int _maxBuffers = -1;

    public WebSocketBuffers(int bufferSize) {
        this._bufferSize = bufferSize;
        this._buffers = BuffersFactory.newBuffers((Buffers.Type)Buffers.Type.DIRECT, (int)bufferSize, (Buffers.Type)Buffers.Type.INDIRECT, (int)bufferSize, (Buffers.Type)Buffers.Type.INDIRECT, (int)-1);
    }

    public Buffer getBuffer() {
        return this._buffers.getBuffer();
    }

    public Buffer getDirectBuffer() {
        return this._buffers.getHeader();
    }

    public void returnBuffer(Buffer buffer) {
        this._buffers.returnBuffer(buffer);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }
}

