/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD12;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD12;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketConnectionD12
extends AbstractConnection
implements WebSocketConnection {
    private static final Logger LOG = Log.getLogger(WebSocketConnectionD12.class);
    static final byte OP_CONTINUATION = 0;
    static final byte OP_TEXT = 1;
    static final byte OP_BINARY = 2;
    static final byte OP_EXT_DATA = 3;
    static final byte OP_CONTROL = 8;
    static final byte OP_CLOSE = 8;
    static final byte OP_PING = 9;
    static final byte OP_PONG = 10;
    static final byte OP_EXT_CTRL = 11;
    static final int CLOSE_NORMAL = 1000;
    static final int CLOSE_SHUTDOWN = 1001;
    static final int CLOSE_PROTOCOL = 1002;
    static final int CLOSE_BADDATA = 1003;
    static final int CLOSE_NOCODE = 1005;
    static final int CLOSE_NOCLOSE = 1006;
    static final int CLOSE_NOTUTF8 = 1007;
    static final int FLAG_FIN = 8;
    static final int VERSION = 8;
    private static final byte[] MAGIC;
    private final IdleCheck _idle;
    private final List<Extension> _extensions;
    private final WebSocketParserD12 _parser;
    private final WebSocketParser.FrameHandler _inbound;
    private final WebSocketGeneratorD12 _generator;
    private final WebSocketGenerator _outbound;
    private final WebSocket _webSocket;
    private final WebSocket.OnFrame _onFrame;
    private final WebSocket.OnBinaryMessage _onBinaryMessage;
    private final WebSocket.OnTextMessage _onTextMessage;
    private final WebSocket.OnControl _onControl;
    private final String _protocol;
    private final int _draft;
    private final ClassLoader _context;
    private volatile int _closeCode;
    private volatile String _closeMessage;
    private volatile boolean _closedIn;
    private volatile boolean _closedOut;
    private int _maxTextMessageSize = -1;
    private int _maxBinaryMessageSize = -1;
    private final WebSocketParser.FrameHandler _frameHandler = new WSFrameHandler();
    private final WebSocket.FrameConnection _connection = new WSFrameConnection();

    static boolean isLastFrame(byte flags) {
        return (flags & 8) != 0;
    }

    static boolean isControlFrame(byte opcode) {
        return (opcode & 8) != 0;
    }

    public WebSocketConnectionD12(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft) throws IOException {
        this(websocket, endpoint, buffers, timestamp, maxIdleTime, protocol, extensions, draft, null);
    }

    public WebSocketConnectionD12(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft, MaskGen maskgen) throws IOException {
        super(endpoint, timestamp);
        this._context = Thread.currentThread().getContextClassLoader();
        if (endpoint instanceof AsyncEndPoint) {
            ((AsyncEndPoint)endpoint).cancelIdle();
        }
        this._draft = draft;
        this._endp.setMaxIdleTime(maxIdleTime);
        this._webSocket = websocket;
        this._onFrame = this._webSocket instanceof WebSocket.OnFrame ? (WebSocket.OnFrame)this._webSocket : null;
        this._onTextMessage = this._webSocket instanceof WebSocket.OnTextMessage ? (WebSocket.OnTextMessage)this._webSocket : null;
        this._onBinaryMessage = this._webSocket instanceof WebSocket.OnBinaryMessage ? (WebSocket.OnBinaryMessage)this._webSocket : null;
        this._onControl = this._webSocket instanceof WebSocket.OnControl ? (WebSocket.OnControl)this._webSocket : null;
        this._generator = new WebSocketGeneratorD12(buffers, this._endp, maskgen);
        this._extensions = extensions;
        if (this._extensions != null) {
            int e = 0;
            for (Extension extension : this._extensions) {
                extension.bind(this._connection, e == extensions.size() - 1 ? this._frameHandler : (WebSocketParser.FrameHandler)extensions.get(e + 1), e == 0 ? this._generator : (WebSocketGenerator)extensions.get(e - 1));
                ++e;
            }
        }
        this._outbound = this._extensions == null || this._extensions.size() == 0 ? this._generator : (WebSocketGenerator)extensions.get(extensions.size() - 1);
        this._inbound = this._extensions == null || this._extensions.size() == 0 ? this._frameHandler : (WebSocketParser.FrameHandler)extensions.get(0);
        this._parser = new WebSocketParserD12(buffers, endpoint, this._inbound, maskgen == null);
        this._protocol = protocol;
        if (this._endp instanceof SelectChannelEndPoint) {
            final SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
            scep.cancelIdle();
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                    scep.scheduleIdle();
                }
            };
            scep.scheduleIdle();
        } else {
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                }
            };
        }
    }

    @Override
    public WebSocket.Connection getConnection() {
        return this._connection;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this._extensions == null) {
            return Collections.emptyList();
        }
        return this._extensions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection handle() throws IOException {
        Thread current = Thread.currentThread();
        ClassLoader oldcontext = current.getContextClassLoader();
        current.setContextClassLoader(this._context);
        try {
            try {
                boolean progress = true;
                while (progress) {
                    int flushed = this._generator.flushBuffer();
                    int filled = this._parser.parseNext();
                    boolean bl = progress = flushed > 0 || filled > 0;
                    if (filled >= 0 && flushed >= 0) continue;
                    this._endp.close();
                    break;
                }
                Object var7_8 = null;
                current.setContextClassLoader(oldcontext);
                this._parser.returnBuffer();
                this._generator.returnBuffer();
            }
            catch (IOException e) {
                try {
                    this._endp.close();
                    throw e;
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            current.setContextClassLoader(oldcontext);
            this._parser.returnBuffer();
            this._generator.returnBuffer();
            if (!this._endp.isOpen()) throw throwable;
            this._idle.access(this._endp);
            if (this._closedIn && this._closedOut && this._outbound.isBufferEmpty()) {
                this._endp.close();
                throw throwable;
            }
            if (this._endp.isInputShutdown() && !this._closedIn) {
                this.closeIn(1006, null);
                throw throwable;
            }
            this.checkWriteable();
            throw throwable;
        }
        if (!this._endp.isOpen()) return this;
        this._idle.access(this._endp);
        if (this._closedIn && this._closedOut && this._outbound.isBufferEmpty()) {
            this._endp.close();
            return this;
        }
        if (this._endp.isInputShutdown() && !this._closedIn) {
            this.closeIn(1006, null);
            return this;
        }
        this.checkWriteable();
        return this;
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._outbound.isBufferEmpty();
    }

    public void idleExpired() {
        long idle = System.currentTimeMillis() - ((SelectChannelEndPoint)this._endp).getIdleTimestamp();
        this.closeOut(1000, "Idle for " + idle + "ms > " + this._endp.getMaxIdleTime() + "ms");
    }

    public boolean isSuspended() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        boolean closed;
        WebSocketConnectionD12 webSocketConnectionD12 = this;
        synchronized (webSocketConnectionD12) {
            boolean bl = closed = this._closeCode == 0;
            if (closed) {
                this._closeCode = 1006;
            }
        }
        if (closed) {
            this._webSocket.onClose(1006, "closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIn(int code, String message) {
        block13: {
            boolean closed;
            boolean closedOut;
            LOG.debug("ClosedIn {} {}", new Object[]{this, message});
            WebSocketConnectionD12 webSocketConnectionD12 = this;
            synchronized (webSocketConnectionD12) {
                closedOut = this._closedOut;
                this._closedIn = true;
                boolean bl = closed = this._closeCode == 0;
                if (closed) {
                    this._closeCode = code;
                    this._closeMessage = message;
                }
            }
            try {
                if (closed) {
                    this._webSocket.onClose(code, message);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (closedOut) {
                        this._endp.close();
                    } else {
                        this.closeOut(code, message);
                    }
                }
                catch (IOException e) {
                    LOG.ignore((Throwable)e);
                }
                throw throwable;
            }
            try {
                if (closedOut) {
                    this._endp.close();
                    break block13;
                }
                this.closeOut(code, message);
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOut(int code, String message) {
        boolean closed;
        boolean close;
        LOG.debug("ClosedOut {} {}", new Object[]{this, message});
        WebSocketConnectionD12 webSocketConnectionD12 = this;
        synchronized (webSocketConnectionD12) {
            close = this._closedIn || this._closedOut;
            this._closedOut = true;
            boolean bl = closed = this._closeCode == 0;
            if (closed) {
                this._closeCode = code;
                this._closeMessage = message;
            }
        }
        try {
            if (closed) {
                this._webSocket.onClose(code, message);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (close) {
                    this._endp.close();
                } else {
                    if (code <= 0) {
                        code = 1000;
                    }
                    byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                    bytes[0] = (byte)(code / 256);
                    bytes[1] = (byte)(code % 256);
                    this._outbound.addFrame((byte)8, (byte)8, bytes, 0, bytes.length);
                }
                this._outbound.flush();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
            throw throwable;
        }
        try {
            if (close) {
                this._endp.close();
            } else {
                if (code <= 0) {
                    code = 1000;
                }
                byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                bytes[0] = (byte)(code / 256);
                bytes[1] = (byte)(code % 256);
                this._outbound.addFrame((byte)8, (byte)8, bytes, 0, bytes.length);
            }
            this._outbound.flush();
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    @Override
    public void fillBuffersFrom(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._outbound.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    @Override
    public void handshake(HttpServletRequest request, HttpServletResponse response, String subprotocol) throws IOException {
        String key = request.getHeader("Sec-WebSocket-Key");
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Sec-WebSocket-Accept", WebSocketConnectionD12.hashKey(key));
        if (subprotocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", subprotocol);
        }
        for (Extension ext : this._extensions) {
            response.addHeader("Sec-WebSocket-Extensions", ext.getParameterizedName());
        }
        response.sendError(101);
        if (this._onFrame != null) {
            this._onFrame.onHandshake(this._connection);
        }
        this._webSocket.onOpen(this._connection);
    }

    public static String hashKey(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(key.getBytes("UTF-8"));
            md.update(MAGIC);
            return new String(B64Code.encode((byte[])md.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "WS/D" + this._draft + "-" + this._endp;
    }

    static {
        try {
            MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface IdleCheck {
        public void access(EndPoint var1);
    }

    private class WSFrameHandler
    implements WebSocketParser.FrameHandler {
        private final Utf8StringBuilder _utf8 = new Utf8StringBuilder();
        private ByteArrayBuffer _aggregate;
        private byte _opcode = (byte)-1;

        private WSFrameHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onFrame(byte flags, byte opcode, Buffer buffer) {
            boolean lastFrame = WebSocketConnectionD12.isLastFrame(flags);
            WebSocketConnectionD12 webSocketConnectionD12 = WebSocketConnectionD12.this;
            synchronized (webSocketConnectionD12) {
                if (WebSocketConnectionD12.this._closedIn) {
                    return;
                }
            }
            try {
                byte[] array = buffer.array();
                if (WebSocketConnectionD12.this._onFrame != null && WebSocketConnectionD12.this._onFrame.onFrame(flags, opcode, array, buffer.getIndex(), buffer.length())) {
                    return;
                }
                if (WebSocketConnectionD12.this._onControl != null && WebSocketConnectionD12.isControlFrame(opcode) && WebSocketConnectionD12.this._onControl.onControl(opcode, array, buffer.getIndex(), buffer.length())) {
                    return;
                }
                switch (opcode) {
                    case 0: {
                        if (WebSocketConnectionD12.this._onTextMessage != null && this._opcode == 1) {
                            if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD12.this._connection.getMaxTextMessageSize())) {
                                if (lastFrame) {
                                    this._opcode = (byte)-1;
                                    String msg = this._utf8.toString();
                                    this._utf8.reset();
                                    WebSocketConnectionD12.this._onTextMessage.onMessage(msg);
                                }
                            } else {
                                this.textMessageTooLarge();
                            }
                        }
                        if (this._opcode < 0 || WebSocketConnectionD12.this._connection.getMaxBinaryMessageSize() < 0 || !this.checkBinaryMessageSize(this._aggregate.length(), buffer.length())) return;
                        this._aggregate.put(buffer);
                        if (!lastFrame || WebSocketConnectionD12.this._onBinaryMessage == null) return;
                        try {
                            WebSocketConnectionD12.this._onBinaryMessage.onMessage(this._aggregate.array(), this._aggregate.getIndex(), this._aggregate.length());
                            return;
                        }
                        finally {
                            this._opcode = (byte)-1;
                            this._aggregate.clear();
                        }
                    }
                    case 9: {
                        LOG.debug("PING {}", new Object[]{this});
                        if (WebSocketConnectionD12.this._closedOut) return;
                        WebSocketConnectionD12.this._connection.sendControl((byte)10, buffer.array(), buffer.getIndex(), buffer.length());
                        return;
                    }
                    case 10: {
                        LOG.debug("PONG {}", new Object[]{this});
                        return;
                    }
                    case 8: {
                        int code = 1005;
                        String message = null;
                        if (buffer.length() >= 2) {
                            code = buffer.array()[buffer.getIndex()] * 256 + buffer.array()[buffer.getIndex() + 1];
                            if (buffer.length() > 2) {
                                message = new String(buffer.array(), buffer.getIndex() + 2, buffer.length() - 2, "UTF-8");
                            }
                        }
                        WebSocketConnectionD12.this.closeIn(code, message);
                        return;
                    }
                    case 1: {
                        if (WebSocketConnectionD12.this._onTextMessage == null) return;
                        if (WebSocketConnectionD12.this._connection.getMaxTextMessageSize() <= 0) {
                            if (lastFrame) {
                                WebSocketConnectionD12.this._onTextMessage.onMessage(buffer.toString("UTF-8"));
                                return;
                            }
                            LOG.warn("Frame discarded. Text aggregation disabled for {}", new Object[]{WebSocketConnectionD12.this._endp});
                            WebSocketConnectionD12.this._connection.close(1003, "Text frame aggregation disabled");
                            return;
                        }
                        if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD12.this._connection.getMaxTextMessageSize())) {
                            if (lastFrame) {
                                String msg = this._utf8.toString();
                                this._utf8.reset();
                                WebSocketConnectionD12.this._onTextMessage.onMessage(msg);
                                return;
                            }
                            this._opcode = 1;
                            return;
                        }
                        this.textMessageTooLarge();
                        return;
                    }
                    default: {
                        if (WebSocketConnectionD12.this._onBinaryMessage == null || !this.checkBinaryMessageSize(0, buffer.length())) return;
                        if (lastFrame) {
                            WebSocketConnectionD12.this._onBinaryMessage.onMessage(array, buffer.getIndex(), buffer.length());
                            return;
                        }
                        if (WebSocketConnectionD12.this._connection.getMaxBinaryMessageSize() >= 0) {
                            this._opcode = opcode;
                            if (this._aggregate == null) {
                                this._aggregate = new ByteArrayBuffer(WebSocketConnectionD12.this._connection.getMaxBinaryMessageSize());
                            }
                            this._aggregate.put(buffer);
                            return;
                        }
                        LOG.warn("Frame discarded. Binary aggregation disabed for {}", new Object[]{WebSocketConnectionD12.this._endp});
                        WebSocketConnectionD12.this._connection.close(1003, "Binary frame aggregation disabled");
                    }
                }
                return;
            }
            catch (ThreadDeath th) {
                throw th;
            }
            catch (Throwable th) {
                LOG.warn(th);
            }
        }

        private boolean checkBinaryMessageSize(int bufferLen, int length) {
            int max = WebSocketConnectionD12.this._connection.getMaxBinaryMessageSize();
            if (max > 0 && bufferLen + length > max) {
                LOG.warn("Binary message too large > {}B for {}", new Object[]{WebSocketConnectionD12.this._connection.getMaxBinaryMessageSize(), WebSocketConnectionD12.this._endp});
                WebSocketConnectionD12.this._connection.close(1003, "Message size > " + WebSocketConnectionD12.this._connection.getMaxBinaryMessageSize());
                this._opcode = (byte)-1;
                if (this._aggregate != null) {
                    this._aggregate.clear();
                }
                return false;
            }
            return true;
        }

        private void textMessageTooLarge() {
            LOG.warn("Text message too large > {} chars for {}", new Object[]{WebSocketConnectionD12.this._connection.getMaxTextMessageSize(), WebSocketConnectionD12.this._endp});
            WebSocketConnectionD12.this._connection.close(1003, "Text message size > " + WebSocketConnectionD12.this._connection.getMaxTextMessageSize() + " chars");
            this._opcode = (byte)-1;
            this._utf8.reset();
        }

        public void close(int code, String message) {
            if (code != 1000) {
                LOG.warn("Close: " + code + " " + message, new Object[0]);
            }
            WebSocketConnectionD12.this._connection.close(code, message);
        }

        public String toString() {
            return WebSocketConnectionD12.this.toString() + "FH";
        }
    }

    private class WSFrameConnection
    implements WebSocket.FrameConnection {
        volatile boolean _disconnecting;

        private WSFrameConnection() {
        }

        public void sendMessage(String content) throws IOException {
            if (WebSocketConnectionD12.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD12.this._closeCode + ":" + WebSocketConnectionD12.this._closeMessage);
            }
            byte[] data = content.getBytes("UTF-8");
            WebSocketConnectionD12.this._outbound.addFrame((byte)8, (byte)1, data, 0, data.length);
            WebSocketConnectionD12.this.checkWriteable();
            WebSocketConnectionD12.this._idle.access(WebSocketConnectionD12.this._endp);
        }

        public void sendMessage(byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD12.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD12.this._closeCode + ":" + WebSocketConnectionD12.this._closeMessage);
            }
            WebSocketConnectionD12.this._outbound.addFrame((byte)8, (byte)2, content, offset, length);
            WebSocketConnectionD12.this.checkWriteable();
            WebSocketConnectionD12.this._idle.access(WebSocketConnectionD12.this._endp);
        }

        public void sendFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD12.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD12.this._closeCode + ":" + WebSocketConnectionD12.this._closeMessage);
            }
            WebSocketConnectionD12.this._outbound.addFrame(flags, opcode, content, offset, length);
            WebSocketConnectionD12.this.checkWriteable();
            WebSocketConnectionD12.this._idle.access(WebSocketConnectionD12.this._endp);
        }

        public void sendControl(byte ctrl, byte[] data, int offset, int length) throws IOException {
            if (WebSocketConnectionD12.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD12.this._closeCode + ":" + WebSocketConnectionD12.this._closeMessage);
            }
            WebSocketConnectionD12.this._outbound.addFrame((byte)8, ctrl, data, offset, length);
            WebSocketConnectionD12.this.checkWriteable();
            WebSocketConnectionD12.this._idle.access(WebSocketConnectionD12.this._endp);
        }

        public boolean isMessageComplete(byte flags) {
            return WebSocketConnectionD12.isLastFrame(flags);
        }

        public boolean isOpen() {
            return WebSocketConnectionD12.this._endp != null && WebSocketConnectionD12.this._endp.isOpen();
        }

        public void close(int code, String message) {
            if (this._disconnecting) {
                return;
            }
            this._disconnecting = true;
            WebSocketConnectionD12.this.closeOut(code, message);
        }

        public void setMaxIdleTime(int ms) {
            try {
                WebSocketConnectionD12.this._endp.setMaxIdleTime(ms);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        public void setMaxTextMessageSize(int size) {
            WebSocketConnectionD12.this._maxTextMessageSize = size;
        }

        public void setMaxBinaryMessageSize(int size) {
            WebSocketConnectionD12.this._maxBinaryMessageSize = size;
        }

        public int getMaxIdleTime() {
            return WebSocketConnectionD12.this._endp.getMaxIdleTime();
        }

        public int getMaxTextMessageSize() {
            return WebSocketConnectionD12.this._maxTextMessageSize;
        }

        public int getMaxBinaryMessageSize() {
            return WebSocketConnectionD12.this._maxBinaryMessageSize;
        }

        public String getProtocol() {
            return WebSocketConnectionD12.this._protocol;
        }

        public byte binaryOpcode() {
            return 2;
        }

        public byte textOpcode() {
            return 1;
        }

        public byte continuationOpcode() {
            return 0;
        }

        public byte finMask() {
            return 8;
        }

        public boolean isControl(byte opcode) {
            return WebSocketConnectionD12.isControlFrame(opcode);
        }

        public boolean isText(byte opcode) {
            return opcode == 1;
        }

        public boolean isBinary(byte opcode) {
            return opcode == 2;
        }

        public boolean isContinuation(byte opcode) {
            return opcode == 0;
        }

        public boolean isClose(byte opcode) {
            return opcode == 8;
        }

        public boolean isPing(byte opcode) {
            return opcode == 9;
        }

        public boolean isPong(byte opcode) {
            return opcode == 10;
        }

        public void disconnect() {
            this.close(1000, null);
        }

        public void setAllowFrameFragmentation(boolean allowFragmentation) {
            WebSocketConnectionD12.this._parser.setFakeFragments(allowFragmentation);
        }

        public boolean isAllowFrameFragmentation() {
            return WebSocketConnectionD12.this._parser.isFakeFragments();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + WebSocketConnectionD12.this._endp.getLocalAddr() + ":" + WebSocketConnectionD12.this._endp.getLocalPort() + "<->" + WebSocketConnectionD12.this._endp.getRemoteAddr() + ":" + WebSocketConnectionD12.this._endp.getRemotePort();
        }
    }
}

