/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.WebSocketFactory;

public abstract class WebSocketHandler
extends HandlerWrapper
implements WebSocketFactory.Acceptor {
    private WebSocketFactory _webSocketFactory;
    private int _bufferSize = 65536;
    private int _maxIdleTime = -1;

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public int getMaxIdleTime() {
        return (int)(this._webSocketFactory == null ? (long)this._maxIdleTime : this._webSocketFactory.getMaxIdleTime());
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
        if (this._webSocketFactory != null) {
            this._webSocketFactory.setMaxIdleTime(maxIdleTime);
        }
    }

    protected void doStart() throws Exception {
        this._webSocketFactory = new WebSocketFactory(this, this._bufferSize);
        if (this._maxIdleTime >= 0) {
            this._webSocketFactory.setMaxIdleTime(this._maxIdleTime);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._webSocketFactory = null;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._webSocketFactory.acceptWebSocket(request, response) || response.isCommitted()) {
            return;
        }
        super.handle(target, baseRequest, request, response);
    }

    public String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }
}

