/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketParser;

public class WebSocketConnection
implements Connection,
WebSocket.Outbound {
    final IdleCheck _idle;
    final EndPoint _endp;
    final WebSocketParser _parser;
    final WebSocketGenerator _generator;
    final long _timestamp;
    final WebSocket _websocket;
    String _key1;
    String _key2;
    ByteArrayBuffer _hixie;

    public WebSocketConnection(WebSocket websocket, EndPoint endpoint) throws IOException {
        this(websocket, endpoint, new WebSocketBuffers(8192), System.currentTimeMillis(), 300000);
    }

    public WebSocketConnection(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime) throws IOException {
        if (endpoint instanceof AsyncEndPoint) {
            ((AsyncEndPoint)endpoint).cancelIdle();
        }
        this._endp = endpoint;
        this._endp.setMaxIdleTime(maxIdleTime);
        this._timestamp = timestamp;
        this._websocket = websocket;
        this._generator = new WebSocketGenerator(buffers, this._endp);
        this._parser = new WebSocketParser(buffers, endpoint, new WebSocketParser.EventHandler(){

            public void onFrame(byte frame, String data) {
                try {
                    WebSocketConnection.this._websocket.onMessage(frame, data);
                }
                catch (ThreadDeath th) {
                    throw th;
                }
                catch (Throwable th) {
                    Log.warn((Throwable)th);
                }
            }

            public void onFrame(byte frame, Buffer buffer) {
                try {
                    byte[] array = buffer.array();
                    WebSocketConnection.this._websocket.onMessage(frame, array, buffer.getIndex(), buffer.length());
                }
                catch (ThreadDeath th) {
                    throw th;
                }
                catch (Throwable th) {
                    Log.warn((Throwable)th);
                }
            }
        });
        if (this._endp instanceof SelectChannelEndPoint) {
            final SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
            scep.cancelIdle();
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                    scep.scheduleIdle();
                }
            };
            scep.scheduleIdle();
        } else {
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                }
            };
        }
    }

    public void setHixieKeys(String key1, String key2) {
        this._key1 = key1;
        this._key2 = key2;
        this._hixie = new IndirectNIOBuffer(16);
    }

    public Connection handle() throws IOException {
        boolean progress = true;
        try {
            if (this._hixie != null) {
                while (progress) {
                    if (this._parser.getBuffer().length() > 0) {
                        int l = this._parser.getBuffer().length();
                        if (l > 8) {
                            l = 8;
                        }
                        this._hixie.put(this._parser.getBuffer().peek(this._parser.getBuffer().getIndex(), l));
                        this._parser.getBuffer().skip(l);
                        progress = true;
                    }
                    if (this._hixie.length() < 8) {
                        int filled = this._endp.fill((Buffer)this._hixie);
                        progress |= filled > 0;
                        if (filled < 0) {
                            this._endp.close();
                            break;
                        }
                    }
                    if (this._hixie.length() != 8) continue;
                    this.doTheHixieHixieShake();
                    this._endp.flush((Buffer)this._hixie);
                    this._hixie = null;
                    this._endp.flush();
                    break;
                }
                WebSocketConnection filled = this;
                return filled;
            }
            while (progress) {
                int flushed = this._generator.flush();
                int filled = this._parser.parseNext();
                boolean bl = progress = flushed > 0 || filled > 0;
                if (filled >= 0 && flushed >= 0) continue;
                this._endp.close();
                break;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (this._endp.isOpen()) {
                this._idle.access(this._endp);
                this.checkWriteable();
            } else {
                this._websocket.onDisconnect();
            }
        }
        return this;
    }

    private void doTheHixieHixieShake() {
        byte[] result = WebSocketGenerator.doTheHixieHixieShake(WebSocketParser.hixieCrypt(this._key1), WebSocketParser.hixieCrypt(this._key2), this._hixie.asArray());
        this._hixie.clear();
        this._hixie.put(result);
    }

    public boolean isOpen() {
        return this._endp != null && this._endp.isOpen();
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._generator.isBufferEmpty();
    }

    public boolean isSuspended() {
        return false;
    }

    public long getTimeStamp() {
        return this._timestamp;
    }

    public void sendMessage(String content) throws IOException {
        this.sendMessage((byte)0, content);
    }

    public void sendMessage(byte frame, String content) throws IOException {
        this._generator.addFrame(frame, content, this._endp.getMaxIdleTime());
        this._generator.flush();
        this.checkWriteable();
        this._idle.access(this._endp);
    }

    public void sendMessage(byte frame, byte[] content) throws IOException {
        this.sendMessage(frame, content, 0, content.length);
    }

    public void sendMessage(byte frame, byte[] content, int offset, int length) throws IOException {
        this._generator.addFrame(frame, content, offset, length, this._endp.getMaxIdleTime());
        this._generator.flush();
        this.checkWriteable();
        this._idle.access(this._endp);
    }

    public void disconnect() {
        try {
            this._generator.flush(this._endp.getMaxIdleTime());
            this._endp.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
    }

    public void fill(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._generator.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    private static interface IdleCheck {
        public void access(EndPoint var1);
    }
}

