/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.UpgradeConnectionException;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;

public abstract class WebSocketHandler
extends HandlerWrapper {
    private WebSocketBuffers _buffers = new WebSocketBuffers(8192);
    private int _bufferSize = 8192;

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    protected void doStart() throws Exception {
        this._buffers = new WebSocketBuffers(this._bufferSize);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._buffers = null;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if ("WebSocket".equals(request.getHeader("Upgrade")) && "HTTP/1.1".equals(request.getProtocol())) {
            String protocol = request.getHeader("WebSocket-Protocol");
            WebSocket websocket = this.doWebSocketConnect(request, protocol);
            if (websocket != null) {
                HttpConnection http = HttpConnection.getCurrentConnection();
                ConnectedEndPoint endp = (ConnectedEndPoint)http.getEndPoint();
                WebSocketConnection connection = new WebSocketConnection(http.getConnector(), this._buffers, (EndPoint)endp, http.getTimeStamp(), websocket);
                String uri = request.getRequestURI();
                String host = request.getHeader("Host");
                String origin = request.getHeader("Origin");
                origin = this.checkOrigin(request, host, origin);
                response.setHeader("Upgrade", "WebSocket");
                response.addHeader("Connection", "Upgrade");
                response.addHeader("WebSocket-Origin", origin);
                response.addHeader("WebSocket-Location", "ws://" + host + uri);
                if (protocol != null) {
                    response.addHeader("WebSocket-Protocol", protocol);
                }
                response.sendError(101, "Web Socket Protocol Handshake");
                response.flushBuffer();
                connection.fill(((HttpParser)http.getParser()).getHeaderBuffer());
                connection.fill(((HttpParser)http.getParser()).getBodyBuffer());
                websocket.onConnect(connection);
                throw new UpgradeConnectionException((Connection)connection);
            }
            response.sendError(503);
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    protected String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }

    protected abstract WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);
}

